//
//  RfidReport.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/13.
//

#ifndef RfidReport_h
#define RfidReport_h


#endif /* RfidReport_h */

// RfidReport.h

#import <Foundation/Foundation.h>

/**
 * @enum RfidDataType
 * @brief Enumeration for different types of RFID data.
 * @ingroup Monitor
 */
typedef NS_ENUM(NSInteger, RfidDataType) {
    EPC,      /**< Electronic Product Code. */
    USR,      /**< User memory. */
    TID,      /**< Tag ID. */
    ACS,      /**< Access Control. */
    Unknown   /**< Unknown data type. */
};

/**
 * @class RfidReport
 * @brief A class for managing RFID report information.
 */
@interface RfidReport : NSObject

/**
 * @brief The raw report dictionary containing RFID details.
 */
@property (nonatomic, strong, readonly) NSDictionary<NSString *, NSString *> *rawReport;

/**
 * @brief Sets the raw report dictionary.
 *
 * @param rawReport The dictionary containing the raw RFID report information.
 */
- (void)setRawReport:(NSDictionary<NSString *, NSString *> *)rawReport;

/**
 * @brief Checks if the RFID operation failed.
 *
 * @return YES if the operation failed, NO otherwise.
 */
- (BOOL)failed;

/**
 * @brief Gets the data from the RFID report.
 *
 * @return A string representing the RFID data.
 */
- (NSString *)data;

/**
 * @brief Gets the data type from the RFID report.
 *
 * @return The data type as an RfidDataType value.
 */
- (RfidDataType)dataType;

/**
 * @brief Checks if the RFID operation was a write operation.
 *
 * @return YES if it was a write operation, NO otherwise.
 */
- (BOOL)isWriteOperation;

@end

