//
//  TsplForm.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/14.
//

#ifndef TsplForm_h
#define TsplForm_h

#import <Foundation/Foundation.h>

#import <UniPRT/TSPL.h>
#import <UniPRT/Barcode1DProperties.h>
#import <UniPRT/Barcode2DProperties.h>
#import <UniPRT/RfidWriteProperties.h>
#import <UniPRT/RfidReadBitField.h>
#import <UniPRT/RfidReadProperties.h>
#import <UniPRT/RfidWriteBitField.h>

/** @cond */

@interface TsplForm : NSObject

@property (nonatomic, strong) NSMutableArray *tsplObjects;
@property (nonatomic, strong) NSString *name;



- (instancetype)initWithName:(NSString *)formName;

- (void)rawContent:(NSString *)rawContent;
- (void)addTsplObject:(id)pglObject;

#if HIDE_PGL_INTERFACES
- (void)scaleWithUnits:(TSPLScaleUnits)units horzRes:(int)horzRes vertRes:(int)vertRes;
- (void)boxWithLineThickness:(int)lineThickness startRow:(int)startRow startCol:(int)startCol endRow:(int)endRow endCol:(int)endCol;
- (void)lineWithLineThickness:(int)lineThickness startRow:(int)startRow startCol:(int)startCol endRow:(int)endRow endCol:(int)endCol;
- (void)textWithStartRow:(int)startRow startCol:(int)startCol vertExpand:(int)vertExpand horzExpand:(int)horzExpand data:(NSString *)data;
- (void)barcode1DWithType:(TSPLBarcodeType1D)bcdType startRow:(int)startRow startCol:(int)startCol bcdData:(NSString *)bcdData;
- (void)barcode1DWithSetup:(Barcode1DProperties *)bcdSetup startRow:(int)startRow startCol:(int)startCol bcdData:(NSString *)bcdData;
- (void)barcode2DWithType:(TSPLBarcodeType2D)bcdType startRow:(int)startRow startCol:(int)startCol bcdData:(NSString *)bcdData;
- (void)barcode2DWithSetup:(Barcode2DProperties *)bcdSetup startRow:(int)startRow startCol:(int)startCol bcdData:(NSString *)bcdData;
- (void)rfidWriteWithProps:(RfidWriteProperties *)writeProps bitField:(RfidWriteBitField *)bitField;
- (void)rfidWriteWithMemBank:(TSPLRfidMemBlock)memBank dataFormat:(TSPLRfidFormat)dataFormat bitCount:(int)bitCount data:(NSString *)data;
- (void)rfidVerifyWithProps:(RfidReadProperties *)readProps readBitField:(RfidReadBitField *)readBitField;

#endif

@end

/** @endcond */

#endif /* TsplForm_h */
