// IMaxicodeMsgStructured.h

#ifndef IMaxicodeMsgStructured_h
#define IMaxicodeMsgStructured_h

#import <Foundation/Foundation.h>
#import <UniPRT/IMaxicodeData.h>

/**
 * @~english
 * @protocol IMaxicodeMsgStructured
 * @brief Maxicode barcode data. Maxicode Free Form carrier message. Only applies to Mode 2 and 3.
 * @ingroup Interface
 * Modes 2, 3 "structured carrier message" requires fields for postal code, country code, and service class.
 *
 * **Message format typically encoded as follows:**
 *
 * - <primaryMsg><secondaryMsg> = <postalCode>Gs<countryCode>Gs<serviceClass>Gs<secondaryMsg>EOT
 *
 * **postal code (6-9 chars), country code (3 digits), service class (3 digits)**
 *
 * - Mode 2 = US: up to 9 digit postal code (all numeric)
 * - Mode 3 = Canada: 6 digit postal code (alphanumeric) Where:
 * - Gs: Group Separator (0x1D)
 * - EOT: End Of Transmit (0x04)
 *
 * @~chinese
 * @protocol IMaxicodeMsgStructured
 * @brief Maxicode 条形码数据。Maxicode 自由格式承载消息。仅适用于模式2和模式3。
 * @ingroup Interface
 * 模式2和3的“结构化承载消息”需要邮政编码、国家代码和服务类别字段。
 *
 * **消息格式通常编码如下：**
 *
 * - <primaryMsg><secondaryMsg> = <postalCode>Gs<countryCode>Gs<serviceClass>Gs<secondaryMsg>EOT
 *
 * **邮政编码（6-9个字符），国家代码（3位数字），服务类别（3位数字）**
 *
 * - 模式2 = 美国：最多9位邮政编码（全数字）
 * - 模式3 = 加拿大：6位邮政编码（字母数字混合）其中：
 * - Gs：组分隔符（0x1D）
 * - EOT：传输结束（0x04）
 *
 * @~Chinese-Traditional
 * @protocol IMaxicodeMsgStructured
 * @brief Maxicode 條形碼數據。Maxicode 自由格式承載消息。僅適用於模式2和模式3。
 * @ingroup Interface
 * 模式2和3的“結構化承載消息”需要郵政編碼、國家代碼和服務類別字段。
 *
 * **消息格式通常編碼如下：**
 *
 * - <primaryMsg><secondaryMsg> = <postalCode>Gs<countryCode>Gs<serviceClass>Gs<secondaryMsg>EOT
 *
 * **郵政編碼（6-9個字符），國家代碼（3位數字），服務類別（3位數字）**
 *
 * - 模式2 = 美國：最多9位郵政編碼（全數字）
 * - 模式3 = 加拿大：6位郵政編碼（字母數字混合）其中：
 * - Gs：組分隔符（0x1D）
 * - EOT：傳輸結束（0x04）
 *
 *
 */

@protocol IMaxicodeMsgStructured <IMaxicodeData>

@property (nonatomic, copy) NSString *postalCode;
@property (nonatomic, copy) NSString *countryCode;
@property (nonatomic, copy) NSString *serviceClass;
@property (nonatomic, copy) NSString *remainingMsg;

@end

#endif /* IMaxicodeMsgStructured_h */

