//
//  IText.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef IText_h
#define IText_h

// IText.h
#import <Foundation/Foundation.h>

#import <UniPRT/ITextSettings.h>
#import <UniPRT/ITextItem.h>

/**
 * @protocol IText
 * @ingroup Interface
 *
 * @~english
 * @brief A protocol defining the interface for Text classes.
 * @~chinese
 * @brief 定义文本类接口的协议。
 * @~chinese_traditional
 * @brief 定義文本類接口的協議。
 */
@protocol IText <ITextSettings>

/**
 * @~english
 * @brief List of text items that use the same text settings.
 *
 * @~chinese
 * @brief 使用相同文本设置的文本项列表。
 *
 * @~chinese_traditional
 * @brief 使用相同文本設置的文本項列表。
 */
@property (nonatomic, strong) NSArray<id<ITextItem>> *text;

/**
 * @~english
 * @brief Returns the string that can be sent to printer.
 *
 * @~chinese
 * @brief 返回可以发送到打印机的字符串。
 *
 * @~chinese_traditional
 * @brief 返回可以發送到打印機的字符串。
 */
- (NSString *)description;
@end

#endif /* IText_h */
