//
//  IBarcodeItem_2D.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef IBarcodeItem_2D_h
#define IBarcodeItem_2D_h
#import <Foundation/Foundation.h>
#import <UniPRT/IPoint.h>

/**
 * @~english
 * @protocol IBarcodeItem_2D
 *
 * @brief Specify barcode content and position on plane where barcode starts.
 *
 * @ingroup Interface
 *
 * @~chinese
 * @protocol IBarcodeItem_2D
 *
 * @brief 指定条码内容和条码在平面上开始的位置。
 *
 * @ingroup Interface
 *
 * @~chinese_traditional
 * @protocol IBarcodeItem_2D
 *
 * @brief 指定條碼內容和條碼在平面上開始的位置。
 *
 * @ingroup Interface
 */
@protocol IBarcodeItem_2D <NSObject>

/**
 * @~english
 * @brief Position where barcode starts.
 *
 * @~chinese
 * @brief 条码开始的位置。
 *
 * @~chinese_traditional
 * @brief 條碼開始的位置。
 */
@property (nonatomic, strong) id<IPoint> start;

/**
 * @~english
 * @brief The barcode content.
 *
 * @~chinese
 * @brief 条码的内容。
 *
 * @~chinese_traditional
 * @brief 條碼的內容。
 */
@property (nonatomic, strong) NSString *data;

@end

#endif /* IBarcodeItem_2D_h */
