//
//  ITextItem.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef ITextItem_h
#define ITextItem_h

// ITextItem.h
#import <Foundation/Foundation.h>

#import <UniPRT/IPoint.h>
#import <UniPRT/IFontSize.h>

/**
 * @protocol ITextItem
 * @ingroup Interface
 *
 * @~english
 * @brief Specify text and position on plane where text starts.
 *
 * @~chinese
 * @brief 指定文本及其在平面上开始的位置。
 *
 * @~chinese_traditional
 * @brief 指定文字及其在平面上開始的位置。
 */
@protocol ITextItem <NSObject>

/**
 * @~english
 * @brief Position where text starts.
 *
 * @~chinese
 * @brief 文本开始的位置。
 *
 * @~chinese_traditional
 * @brief 文字開始的位置。
 */
@property (nonatomic, strong) id<IPoint> start;

/**
 * @~english
 * @brief The text content.
 *
 * @~chinese
 * @brief 文本内容。
 *
 * @~chinese_traditional
 * @brief 文字內容。
 */
@property (nonatomic, strong) NSString *data;

/**
 * @~english
 * @brief Horizontal/Vertical font size. 0 for default no scaling/resizing. 0-100% scaling or size in points (1/72 inch) or ruler.
 *
 * Size will depend on FontSizeUnitsEnum setting.
 *
 * @~chinese
 * @brief 水平/垂直字体大小。0 表示默认不缩放/调整大小。0-100% 缩放或以点为单位的大小（1/72 英寸）或标尺。
 *
 * 大小取决于 FontSizeUnitsEnum 设置。
 *
 * @~chinese_traditional
 * @brief 水平/垂直字體大小。0 表示默認不縮放/調整大小。0-100% 縮放或以點為單位的大小（1/72 英寸）或標尺。
 *
 * 大小取決於 FontSizeUnitsEnum 設定。
 */
@property (nonatomic, strong) id<IFontSize> fontSize;
@end


#endif /* ITextItem_h */
