//
//  RotateEnum.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef RotateEnum_h
#define RotateEnum_h

#import <Foundation/Foundation.h>

/**
 * @~english
 * @class RotateEnum
 * @brief Direction/Rotation for objects commands that support rotation.
 * @ingroup Interface
 *
 * | Value                              | Description                                                                                   |
 * |---------------------------------|-------------------------------------------------------------------------------------|
 * | RotateEnumNone                   | No rotation. |
 * | RotateEnumClockwise              | 90 Degrees clockwise rotation. |
 * | RotateEnumCounterClockwise       | 90 Degrees counter clockwise rotation. 270 Degrees clockwise rotation. |
 * | RotateEnumInverted               | 180 Degrees clockwise rotation. |
 *
 * @~chinese
 * @class RotateEnum
 * @brief 支持旋转的对象命令的方向/旋转。
 * @ingroup Interface
 *
 * | 值                                  | 描述                                                                                      |
 * |---------------------------------|-------------------------------------------------------------------------------------|
 * | RotateEnumNone                   | 无旋转。 |
 * | RotateEnumClockwise              | 顺时针旋转90度。 |
 * | RotateEnumCounterClockwise       | 逆时针旋转90度。顺时针旋转270度。 |
 * | RotateEnumInverted               | 顺时针旋转180度。 |
 *
 * @~chinese_traditional
 * @class RotateEnum
 * @brief 支持旋轉的對象命令的方向/旋轉。
 * @ingroup Interface
 *
 * | 值                                  | 描述                                                                                      |
 * |---------------------------------|-------------------------------------------------------------------------------------|
 * | RotateEnumNone                   | 無旋轉。 |
 * | RotateEnumClockwise              | 順時針旋轉90度。 |
 * | RotateEnumCounterClockwise       | 逆時針旋轉90度。順時針旋轉270度。 |
 * | RotateEnumInverted               | 順時針旋轉180度。 |
 */
typedef NS_ENUM(NSInteger, RotateEnum) {
    RotateEnumNone,                   ///< @~english No rotation. @~chinese 无旋转。 @~chinese_traditional 無旋轉。
    RotateEnumClockwise,              ///< @~english 90 Degrees clockwise rotation. @~chinese 顺时针旋转90度。 @~chinese_traditional 順時針旋轉90度。
    RotateEnumCounterClockwise,       ///< @~english 90 Degrees counter clockwise rotation. 270 Degrees clockwise rotation. @~chinese 逆时针旋转90度。顺时针旋转270度。 @~chinese_traditional 逆時針旋轉90度。順時針旋轉270度。
    RotateEnumInverted                ///< @~english 180 Degrees clockwise rotation. @~chinese 顺时针旋转180度。 @~chinese_traditional 順時針旋轉180度。
};

#endif /* RotateEnum_h */
