//
//  ILabel.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef ILabel_h
#define ILabel_h

#import <Foundation/Foundation.h>

/**
 * \~English
 * @protocol ILabel
 * @brief Label is the container for other objects that are printed.
 * @ingroup Interface
 *
 * \~Chinese
 * @protocol ILabel
 * @brief 标签是用于容纳其他打印对象的容器。
 * @ingroup Interface
 *
 * \~Chinese-Traditional
 * @protocol ILabel
 * @brief 標籤是用於容納其他打印對象的容器。
 * @ingroup Interface
 */
@protocol ILabel <NSObject>

/**
 * \~English
 * @brief Name of label that may be used to identify it from other labels.
 *
 * \~Chinese
 * @brief 标签的名称，可用于将其与其他标签区分开来。
 *
 * \~Chinese-Traditional
 * @brief 標籤的名稱，可用於將其與其他標籤區分開來。
 */
@property (nonatomic, strong) NSString *name;

/**
 * \~English
 * @brief Add object that can be converted to printer language syntax.
 *
 * \~Chinese
 * @brief 添加可以转换为打印机语言语法的对象。
 *
 * \~Chinese-Traditional
 * @brief 添加可以轉換為打印機語言語法的對象。
 */
- (void)addObject:(id)addObject;

/**
 * \~English
 * @brief Raw content added to label for cases where custom content needs to be added.
 *
 * Adding raw content allows adding of printer language commands or other features that may not be available.
 *
 * No formatting of content is done. Caller responsible for making sure content follows printer language syntax.
 *
 * \~Chinese
 * @brief 为需要添加自定义内容的情况添加原始内容到标签。
 *
 * 添加原始内容可以添加打印机语言命令或其他可能不可用的功能。
 *
 * 不会对内容进行格式化。调用者负责确保内容符合打印机语言语法。
 *
 * \~Chinese-Traditional
 * @brief 為需要添加自定義內容的情況添加原始內容到標籤。
 *
 * 添加原始內容可以添加打印機語言命令或其他可能不可用的功能。
 *
 * 不會對內容進行格式化。調用者負責確保內容符合打印機語言語法。
 */
- (void)addRawContent:(NSString *)rawContent;

/**
 * \~English
 * @brief Returns the string that can be sent to printer.
 *
 * \~Chinese
 * @brief 返回可以发送到打印机的字符串。
 *
 * \~Chinese-Traditional
 * @brief 返回可以發送到打印機的字符串。
 */
- (NSString *)description;

@end

#endif /* ILabel_h */
