//
//  ImpChannel.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/2.
//

#ifndef ImpChannel_h
#define ImpChannel_h


#endif /* ImpChannel_h */

#import <Foundation/Foundation.h>

@interface ImpChannel : NSObject {
    NSMutableArray *dataQueue;  // 使用 NSMutableArray 来存储数据
    NSCondition *condition;      // 使用 NSCondition 代替 std::condition_variable
    BOOL completed;              // 标记通道是否完成
    NSUInteger capacity;         // 容量限制
    NSString *channelId;        // 通道 ID
}

// 方法声明
- (void)send:(id)msg;
- (id)receive;
- (void)complete;
- (void)reset;
- (BOOL)isEmpty;
- (id)front;
- (void)pop;
- (BOOL)waitToRead;
- (BOOL)waitToReadWithTimeout:(NSTimeInterval)timeout;
- (BOOL)tryRead:(id *)msg;
- (void)setCapacity:(NSUInteger)newCapacity;
- (id)getAt:(NSUInteger)index;
- (NSUInteger)size;
- (NSString *)getId;
- (void)setEmpty;

@end
