//
//  PglForm.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/23.
//

#ifndef PglForm_h
#define PglForm_h

#import <Foundation/Foundation.h>

#import <UniPRT/PGL.h>
#import <UniPRT/PglBarcode1DProperties.h>
#import <UniPRT/PglBarcode2DProperties.h>
#import <UniPRT/PglRfidWriteProperties.h>
#import <UniPRT/PglRfidWriteBitField.h>
#import <UniPRT/PglRfidReadProperties.h>
#import <UniPRT/PglRfidReadBitField.h>
#import <UniPRT/PglBarcode1DProperties.h>
#import <UniPRT/PglBarcode1D.h>
#import <UniPRT/PglBarcode2DProperties.h>
#import <UniPRT/PglBarcode2D.h>


NS_ASSUME_NONNULL_BEGIN

/** @cond */

@interface PglForm : NSObject

@property (nonatomic, copy) NSString *name;
@property (nonatomic, assign) BOOL deleteAfterUse;
@property (nonatomic, strong) NSMutableArray *pglObjects;

- (instancetype)initWithName:(NSString *)formName;
- (void)rawContent:(NSString *)rawContent;
- (void)scaleWithUnits:(PGLScaleUnits)units horzRes:(int)horzRes vertRes:(int)vertRes;
- (void)boxWithLineThickness:(int)lineThickness startRow:(int)startRow startCol:(int)startCol endRow:(int)endRow endCol:(int)endCol;
- (void)lineWithLineThickness:(int)lineThickness startRow:(int)startRow startCol:(int)startCol endRow:(int)endRow endCol:(int)endCol;
- (void)textWithStartRow:(int)startRow startCol:(int)startCol vertExpand:(int)vertExpand horzExpand:(int)horzExpand data:(NSString *)data;
- (void)barcode1DWithType:(PGLBarcodeType1D)bcdType startRow:(int)startRow startCol:(int)startCol bcdData:(NSString *)bcdData;
- (void)barcode1DWithSetup:(PglBarcode1DProperties *)bcdSetup startRow:(int)startRow startCol:(int)startCol bcdData:(NSString *)bcdData;
- (void)barcode2DWithType:(PGLBarcodeType2D)bcdType startRow:(int)startRow startCol:(int)startCol bcdData:(NSString *)bcdData;
- (void)barcode2DWithSetup:(PglBarcode2DProperties *)bcdSetup startRow:(int)startRow startCol:(int)startCol bcdData:(NSString *)bcdData;
- (void)rfidWriteWithProps:(PglRfidWriteProperties *)writeProps bitField:(PglRfidWriteBitField *)bitField;
- (void)rfidWriteWithMemBank:(PGLRfidMemBlock)memBank dataFormat:(PGLRfidFormat)dataFormat bitCount:(int)bitCount data:(NSString *)data;
- (void)addPglObject:(id)pglObject;
- (void)rfidVerifyWithProps:(PglRfidReadProperties *)readProps readBitField:(PglRfidReadBitField *)readBitField;
- (NSString *)getAsString;

@end

/** @endcond */

NS_ASSUME_NONNULL_END

#endif /* PglForm_h */
