//
//  _PglText.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/24.
//

#ifndef _PglText_h
#define _PglText_h

#import <Foundation/Foundation.h>

#import <UniPRT/AText.h>
#import <UniPRT/PglFont.h>
#import <UniPRT/PrintPlane.h>
#import <UniPRT/PglTranslate.h>
#import <UniPRT/Defaults.h>
#import <UniPRT/PglAlphanumeric.h>
#import <UniPRT/FontSize.h>

/**
 * \~English
 * @class _PglText
 * @brief A class representing a text object.
 *
 * This class inherits from AText and provides functionality for initializing and describing text objects.
 *
 * @ingroup PGL
 *
 * \~Chinese
 * @class _PglText
 * @brief 表示文本对象的类。
 *
 * 该类继承自AText并提供了初始化和描述文本对象的功能。
 *
 * @ingroup PGL
 *
 * \~Chinese-Traditional
 * @class _PglText
 * @brief 表示文本對象的類。
 *
 * 該類繼承自AText並提供了初始化和描述文本對象的功能。
 *
 * @ingroup PGL
 */
@interface _PglText : AText

/**
 * \~English
 * @brief Initializes a new instance of the _PglText class.
 *
 * @return A new instance of _PglText.
 *
 * \~Chinese
 * @brief 初始化_PglText类的新实例。
 *
 * @return _PglText的新实例。
 *
 * \~Chinese-Traditional
 * @brief 初始化_PglText類的新實例。
 *
 * @return _PglText的新實例。
 */
- (instancetype)init;

/**
 * \~English
 * @brief Initializes a new instance of the _PglText class with the specified text item.
 *
 * @param text List of text items that use the same text settings.
 * @return A new instance of _PglText.
 *
 * \~Chinese
 * @brief 使用指定的文本项目初始化_PglText类的新实例。
 *
 * @param text 使用相同文本设置的文本项目列表。
 * @return _PglText的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的文本項目初始化_PglText類的新實例。
 *
 * @param text 使用相同文本設置的文本項目列表。
 * @return _PglText的新實例。
 */
- (instancetype)initWithText:(id<ITextItem>)text;

/**
 * \~English
 * @brief Returns a string that can be sent to the printer.
 *
 * This method generates a string representation of the _PglText instance that
 * is formatted and ready to be sent to a printer. The string includes all the
 * necessary commands and data required for printing.
 *
 * @return A string description of the _PglText instance.
 *
 * \~Chinese
 * @brief 返回一个可以发送到打印机的字符串。
 *
 * 此方法生成_PglText实例的字符串表示，该字符串已格式化并准备好发送到打印机。字符串包含所有打印所需的命令和数据。
 *
 * @return _PglText实例的字符串描述。
 *
 * \~Chinese-Traditional
 * @brief 返回一個可以發送到打印機的字符串。
 *
 * 此方法生成_PglText實例的字符串表示，該字符串已格式化並準備好發送到打印機。字符串包含所有打印所需的命令和數據。
 *
 * @return _PglText實例的字符串描述。
 */
- (NSString *)description;

@end

#endif /* _PglText_h */
