//
//  IBarcode2D.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef IBarcode2D_h
#define IBarcode2D_h

#import <Foundation/Foundation.h>

#import <UniPRT/IBarcodeItem_2D.h>
#import <UniPRT/IPositionRuler.h>
#import <UniPRT/IRotation.h>

/**
 * @~english
 * @protocol IBarcode2D
 * @brief A protocol defining the interface for Barcode2D classes.
 * @ingroup Interface
 *
 * @~chinese
 * @protocol IBarcode2D
 * @brief 定义 Barcode2D 类接口的协议。
 * @ingroup Interface
 *
 * @~chinese_traditional
 * @protocol IBarcode2D
 * @brief 定義 Barcode2D 類接口的協議。
 * @ingroup Interface
 */

@protocol IBarcode2D <IBarcodeItem_2D, IPositionRuler, IRotation>

/**
 * @~english
 * @brief Returns the string that can be sent to printer.
 *
 * @~chinese
 * @brief 返回可以发送到打印机的字符串。
 *
 * @~chinese_traditional
 * @brief 返回可以發送到打印機的字符串。
 */

- (NSString *)description;

@end

#endif /* IBarcode2D_h */
