//
//  IBarcode_1D_Properties.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef IBarcode_1D_Properties_h
#define IBarcode_1D_Properties_h

#import <Foundation/Foundation.h>

#import <UniPRT/IRuler.h>
#import <UniPRT/IBarWidths.h>
#import <UniPRT/IBarcodeType1D.h>
#import <UniPRT/IRotation.h>

/**
 * @~english
 * @protocol IBarcode_1D_Properties
 * @brief A protocol defining the interface for Barcode1D classes.
 * @ingroup Interface
 *
 * @~chinese
 * @protocol IBarcode_1D_Properties
 * @brief 定义一维条码类接口的协议。
 * @ingroup Interface
 *
 * @~chinese_traditional
 * @protocol IBarcode_1D_Properties
 * @brief 定義一維條碼類接口的協議。
 * @ingroup Interface
 */
@protocol IBarcode_1D_Properties <IRotation, IBarcodeType1D>

/**
 * @~english
 * @brief Ruler to use for positioning and Height.
 *
 * @~chinese
 * @brief 用于定位和高度的标尺。
 *
 * @~chinese_traditional
 * @brief 用於定位和高度的標尺。
 */
@property (nonatomic, strong) id<IRuler> ruler;

/**
 * @~english
 * @brief Barcode magnification. Width of Narrow/Wide bars.
 *
 * @~chinese
 * @brief 条码放大。窄条/宽条的宽度。
 *
 * @~chinese_traditional
 * @brief 條碼放大。窄條/寬條的寬度。
 */
@property (nonatomic, strong) id<IBarWidths> barWidths;

/**
 * @~english
 * @brief Prints the PDF human readable at bottom of barcode.
 *
 * @~chinese
 * @brief 在条码底部打印可读的PDF文本。
 *
 * @~chinese_traditional
 * @brief 在條碼底部打印可讀的PDF文本。
 */
@property (nonatomic, assign) BOOL printHumanReadable;

@end

#endif /* IBarcode_1D_Properties_h */
