//
//  MaxicodeMsgStructured.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/16.
//

#ifndef MaxicodeMsgStructured_h
#define MaxicodeMsgStructured_h

#import <Foundation/Foundation.h>
#import <UniPRT/AMaxicodeMsgStructured.h>

/**
 * \~English
 * @class MaxicodeMsgStructured
 * @brief A class representing a structured Maxicode message for TSPL.
 *
 * This class inherits from AMaxicodeMsgStructured and provides functionality for
 * initializing and accessing the data of a structured Maxicode message in TSPL.
 *
 * @ingroup TSPL
 *
 * \~Chinese
 * @class MaxicodeMsgStructured
 * @brief 表示用于 TSPL 的结构化 Maxicode 消息的类。
 *
 * 该类继承自 AMaxicodeMsgStructured，并提供了在 TSPL 中初始化和访问结构化 Maxicode 消息数据的功能。
 *
 * @ingroup TSPL
 *
 * \~Chinese-Traditional
 * @class MaxicodeMsgStructured
 * @brief 表示用於 TSPL 的結構化 Maxicode 消息的類。
 *
 * 該類繼承自 AMaxicodeMsgStructured，並提供了在 TSPL 中初始化和訪問結構化 Maxicode 消息數據的功能。
 *
 * @ingroup TSPL
 */
@interface MaxicodeMsgStructured : AMaxicodeMsgStructured

/**
 * \~English
 * @brief Initializes a new instance of the MaxicodeMsgStructured class with the specified mode, postal code, country code, service class, and remaining message.
 *
 * @param mode The mode of the Maxicode.
 * @param postalCode The postal code to be encoded.
 * @param countryCode The country code to be encoded.
 * @param serviceClass The service class to be encoded.
 * @param remainingMsg The remaining message to be encoded.
 * @return A new instance of MaxicodeMsgStructured.
 *
 * \~Chinese
 * @brief 使用指定的模式、邮政编码、国家代码、服务类别和剩余消息初始化 MaxicodeMsgStructured 类的新实例。
 *
 * @param mode Maxicode 的模式。
 * @param postalCode 要编码的邮政编码。
 * @param countryCode 要编码的国家代码。
 * @param serviceClass 要编码的服务类别。
 * @param remainingMsg 要编码的剩余消息。
 * @return MaxicodeMsgStructured 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的模式、郵政編碼、國家代碼、服務類別和剩餘消息初始化 MaxicodeMsgStructured 類的新實例。
 *
 * @param mode Maxicode 的模式。
 * @param postalCode 要編碼的郵政編碼。
 * @param countryCode 要編碼的國家代碼。
 * @param serviceClass 要編碼的服務類別。
 * @param remainingMsg 要編碼的剩餘消息。
 * @return MaxicodeMsgStructured 的新實例。
 */
- (instancetype)initWithMode:(MaxicodeModeEnum)mode postalCode:(NSString *)postalCode countryCode:(NSString *)countryCode serviceClass:(NSString *)serviceClass remainingMsg:(NSString *)remainingMsg;

/**
 * \~English
 * @brief The encoded data of the Maxicode message.
 *
 * \~Chinese
 * @brief Maxicode 消息的编码数据。
 *
 * \~Chinese-Traditional
 * @brief Maxicode 消息的編碼數據。
 */
@property (nonatomic, readonly) NSString *data;

@end

#endif /* MaxicodeMsgStructured_h */
