//
//  QRCodeMaskEnum.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef QRCodeMaskEnum_h
#define QRCodeMaskEnum_h

#import <Foundation/Foundation.h>

/**
 * \~English
 * @class QRCodeMaskEnum
 * @brief The QR Mask changes the QR barcode generated by changing the distribution of light and dark cells.
 *
 * Using different masks may result in making the QR Code easier to read by a barcode scanner.
 * @ingroup Interface
 *
 * \~Chinese
 * @class QRCodeMaskEnum
 * @brief QR掩码通过改变亮暗单元格的分布来改变生成的QR条码。
 *
 * 使用不同的掩码可能会使条码扫描器更容易读取QR码。
 * @ingroup Interface
 *
 * \~Chinese-Traditional
 * @class QRCodeMaskEnum
 * @brief QR掩碼通過改變亮暗單元格的分佈來改變生成的QR條碼。
 *
 * 使用不同的掩碼可能會使條碼掃描器更容易讀取QR碼。
 * @ingroup Interface
 */
typedef NS_ENUM(NSUInteger, QRCodeMaskEnum) {
    QRCodeMask0 = 0, ///< \~English Mask 0 \~Chinese 掩码0 \~Chinese-Traditional 掩碼0
    QRCodeMask1,     ///< \~English Mask 1 \~Chinese 掩码1 \~Chinese-Traditional 掩碼1
    QRCodeMask2,     ///< \~English Mask 2 \~Chinese 掩码2 \~Chinese-Traditional 掩碼2
    QRCodeMask3,     ///< \~English Mask 3 \~Chinese 掩码3 \~Chinese-Traditional 掩碼3
    QRCodeMask4,     ///< \~English Mask 4 \~Chinese 掩码4 \~Chinese-Traditional 掩碼4
    QRCodeMask5,     ///< \~English Mask 5 \~Chinese 掩码5 \~Chinese-Traditional 掩碼5
    QRCodeMask6,     ///< \~English Mask 6 \~Chinese 掩码6 \~Chinese-Traditional 掩碼6
    QRCodeMask7,     ///< \~English Mask 7 \~Chinese 掩码7 \~Chinese-Traditional 掩碼7
    QRCodeMask8      ///< \~English Mask 8 \~Chinese 掩码8 \~Chinese-Traditional 掩碼8
};

#endif /* QRCodeMaskEnum_h */
