//
//  ILabel.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef ILabel_h
#define ILabel_h

// ILabel.h
#import <Foundation/Foundation.h>

@protocol ILabel <NSObject>

// Name of label that may be used to identify it from other labels.
@property (nonatomic, strong) NSString *name;

// Add object that can be converted to printer language syntax.
- (void)addObject:(id)addObject;

// Raw content added to label for cases where custom content needs to be added.
- (void)addRawContent:(NSString *)rawContent;

// Returns the string that can be sent to printer.
- (NSString *)description;

@end

#endif /* ILabel_h */
