﻿#include <cstdio>
#include <iostream>
#include <cstring>
#include <vector>
#include <string>
#include <dlfcn.h> // 包含動態加載庫的頭文件
#include <sstream>
#include <thread>
#include <chrono>
#include <mutex>


enum DescriptorPortType {

    // Data
    DATA,
    // Management
    MGMT,
    // Status
    STATUS
};

typedef unsigned char byte;

void* handleLib;

typedef int (*BytesAvailableFunc)();
typedef bool (*ConnectedFunc)();
typedef void (*ReadFunc)(byte* buffer, int size);
typedef void (*WriteFunc)(byte* dataOut, int iDataSize);
typedef byte* (*WriteAndWaitForResponseFunc)(byte* dataOut, int iDataSize, int responseStartTimeOut, int responseEndTimeOut, char* completetionToken);
typedef void (*CloseFunc)();
typedef void (*OpenFunc)();
typedef void (*TcpConnectFunc)(char* ipAddress, int port);



BytesAvailableFunc pBytesAvailable = NULL;
ConnectedFunc pConnected = NULL;
ReadFunc pRead = NULL;
WriteFunc pWrite = NULL;
WriteAndWaitForResponseFunc pWriteAndWaitForResponse = NULL;
CloseFunc pClose = NULL;
OpenFunc pOpen = NULL;
TcpConnectFunc pTcpConnect = NULL;


bool _bAsyncListening = false;
bool _bConnected = false;
std::mutex _mutex;
std::thread listenerThread_;
std::string currentText;


void ListenerAsync() 
{
    while (_bAsyncListening && pConnected()) {
        std::this_thread::sleep_for(std::chrono::milliseconds(500));

        if (!_bAsyncListening)
            break;

        std::lock_guard<std::mutex> lock(_mutex);

        
        int iBytes = pBytesAvailable();
        byte* pBuf = nullptr; 

        if (!_bAsyncListening)
            break;

        if (iBytes > 0) {
           
            pBuf = new byte[iBytes];
            pRead(pBuf, iBytes);

            if (!_bAsyncListening)
                break;

            std::string str(reinterpret_cast<char*>(pBuf), iBytes);
            currentText += str;
            std::cout << std::endl;
            std::cout << std::endl;
            std::cout << "Response:";
            std::cout << currentText << std::endl;

            delete[] pBuf;
        }
        else {
            std::this_thread::sleep_for(std::chrono::milliseconds(10));
        }
    }

}




void RunAsyncListen() 
{

    if (_bAsyncListening) {
        std::cout << "---Deactivate Listener" << std::endl;
        _bAsyncListening = false;
        if (listenerThread_.joinable()) {
            listenerThread_.join();
        }
    }
    else {
        if (!pConnected()) {
            std::cerr << "Connect first. Can't listen without a valid open/active connection." << std::endl;
            return;
        }
        std::cout << "Listening....." << std::endl;
        _bAsyncListening = true;
        listenerThread_ = std::thread(ListenerAsync);
        listenerThread_.detach();
        std::this_thread::sleep_for(std::chrono::seconds(1));
    }

}



int main()
{
    //printf("來自 %s 的問候!\n", "TestCommSDK");

    // 加載 libCommSDK.so 庫
    handleLib = dlopen("libCommSDK.so", RTLD_LAZY);
    if (!handleLib) {
        std::cerr << "Failed to load libCommSDK.so: " << dlerror() << std::endl;
        return 1;
    }

    pBytesAvailable = reinterpret_cast<BytesAvailableFunc>(dlsym(handleLib, "BytesAvailable"));
    pConnected = reinterpret_cast<ConnectedFunc>(dlsym(handleLib, "Connected"));
    pRead = reinterpret_cast<ReadFunc>(dlsym(handleLib, "Read"));
    pWrite = reinterpret_cast<WriteFunc>(dlsym(handleLib, "Write"));
    pWriteAndWaitForResponse = reinterpret_cast<WriteAndWaitForResponseFunc>(dlsym(handleLib, "WriteAndWaitForResponse"));
    pClose = reinterpret_cast<CloseFunc>(dlsym(handleLib, "Close"));
    pOpen = reinterpret_cast<OpenFunc>(dlsym(handleLib, "Open"));
    pTcpConnect = reinterpret_cast<TcpConnectFunc>(dlsym(handleLib, "TcpConnect"));
    
  

    if ( !pBytesAvailable || !pConnected || !pRead || !pWrite || !pWriteAndWaitForResponse || !pOpen || !pTcpConnect )
    {
        std::cerr << "Failed to get address of libCommSDK.so API functions: " << dlerror() << std::endl;
        dlclose(handleLib);
        return 1;
    }    
    
   
    pTcpConnect("10.0.10.185", 9100);
    

    pOpen();

    if (pConnected())
    {
        std::string content;

        // Print Job
        
       
        content += "SIZE 3,2\r\n";
        content += "GAP 0 mm, 0 mm\r\n";
        content += "DIRECTION 1\r\n";
        content += "CLS\r\n";
        content += "TEXT 10, 30, \"3\", 0, 1, 1, \"123456\"\r\n";
        content += "BARCODE 10, 100, \"EAN13\", 80, 1, 0, 2, 4, \"123456789012\"\r\n";
        content += "TEXT 10, 70, \"4\", 0, 1, 1, \"TEST PRINTOUT\"\r\n";
        content += "PRINT 1, 1\r\n";
        
        
        /*
        content += "!PTX_SETUP\r\n";
        content += "PRINTJOB - START; 1234\r\n";
        content += "PTX_END\r\n";

        content += "~NORMAL\r\n";

        content += "~CREATE; PTX; 432\r\n";
        content += "ALPHA\r\n";
        content += "5.7; 8; 1; 1; *PRINTRONIX*\r\n";
        content += "STOP\r\n";
        content += "BARCODE\r\n";
        content += "DATAMATRIX; 2; 10\r\n";
        content += "*PRINTRONIX*\r\n";
        content += "STOP\r\n";
        content += "END\r\n";
        content += "~EXECUTE; PTX; 1\r\n";

        content += "~NORMAL\r\n";

        content += "!PTX_SETUP\r\n";
        content += "PRINTJOB - END; 1234\r\n";
        content += "PTX_END\r\n";
        */

        
        // Print Job

       

        //AsyncListen
        //RunAsyncListen();
        //content += "A$=\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\"\r\n";
        //content += "OUT A$\r\n";
        //AsyncListen

        
        std::cout << std::endl;
        std::cout << "Send to Printer:" << std::endl;
        std::cout << content;
        const char* pStr = content.c_str();
        pWrite((byte*)pStr, strlen(pStr));
        



        // WriteAndWaitForResponse
        /*
        content += "FEED 100\r\n";
        content += "OUT \"12345678\"\r\n";
        std::cout << std::endl;
        std::cout << "Send to Printer:" << std::endl;
        std::cout << content;
        const char* pStr = content.c_str();
        byte* pResponse = pWriteAndWaitForResponse((byte*)pStr, content.size(), 1000, 500, "\r\n");
        std::string str(reinterpret_cast<char*>(pResponse), strlen(reinterpret_cast<char*>(pResponse)));
        std::cout << std::endl;
        std::cout << std::endl;
        std::cout << "Response:";
        std::cout << str << std::endl;
        */
        // WriteAndWaitForResponse

       

    }
    else
    {
        std::cerr << "Failed to Connect Printer " << dlerror() << std::endl;
        dlclose(handleLib);
        return 1;
    }


    int userInput;

    // 循環等待用戶輸入，直到用戶輸入0為止
    do {

        std::cout << std::endl;
        std::cout << std::endl;
        std::cout << "Press 0 to exit";
        std::cout << std::endl;
        std::cin >> userInput;
    } while (userInput != 0);

    // 使用者輸入0後程式結束
    std::cout << std::endl;
    std::cout << "Program exit" << std::endl;
    std::cout << std::endl;

    _bAsyncListening = false;

    pClose();
    // 釋放 libCommSDK.so 庫
    dlclose(handleLib);

    return 0;
}