#pragma once
#include <cstdlib> // for malloc
#include <cstdint> // for uint64_t


typedef unsigned char byte;


enum COMM_IDX
{
    TCP_COMM = 1
};




enum DescriptorPortType {
    DATA,
    MGMT,
    STATUS
};



// Define the function prototypes
extern "C" {

    int BytesAvailable();
    bool Connected();
    void Read(byte* buffer, int size);
    void Write(byte* dataOut, int iDataSize);
    byte* WriteAndWaitForResponse(byte* dataOut, int iDataSize, int responseStartTimeOut, int responseEndTimeOut, char* completetionToken);
    void Close();
    void Open();
    void SendPrintFile(char* ipAddress, char* fileName);
    void SendPrintString(char* ipAddress, char* data, int iDataSize);
    void TcpConnect(char* ipAddress, int port);
    void GetComm(void*& ptrComm);

}
