﻿package com.test.AutoIdSdk;

import java.util.Arrays;
import com.AutoId.Sdk.Json.PrinterMonitor;

public class PrinterMonitorSnippet  {

    // setup a comm and xml parser for listening to xml msgs from printer
    private static PrinterMonitor _PrinterMntr = null;

    public static void main(String[] args) {
        System.out.println("Monitoring Printer.");
        try {
            _PrinterMntr = new PrinterMonitor("192.168.1.57");

            // setup for listening for alerts
            _PrinterMntr.SetAlertStatusListening(true);     // enable unsolicited alert status msgs from printer
            _PrinterMntr.SetAlertStatusCallback(PrinterMonitorSnippet::PtrAlertNoticeListener);

            // setup for listening for Engine Status
            _PrinterMntr.SetEngineStatusListening(true);     // enable unsolicited engine status msgs from printer
            _PrinterMntr.SetEngineStatusCallback(PrinterMonitorSnippet::PtrEngineStatusNoticeListener);

            // setup for listening for display text msgs
            _PrinterMntr.SetDisplayStatusListening(true);     // enable unsolicited display text msgs from printer
            _PrinterMntr.SetDisplayStatusCallback(PrinterMonitorSnippet::PtrDisplayStatusNoticeListener);

            while (true) {   // wait for something to happen
                // pretend to be busy doing some other work here...
                Thread.sleep(1000); // simulate work
            }
        } catch (Exception e) {
            System.out.printf("Exception Msg: %s%n", e.getMessage());
        } finally {
            if (_PrinterMntr != null) {
                _PrinterMntr.Dispose();
            }
        }
    }

    private static void PtrAlertNoticeListener(String[] newAlertText) {
        // Print out alerts: e.g. "2418" ("Print Head Open" fault/alert)
        System.out.printf("Printer Alert #: %n  %s - %s%n", newAlertText[0], newAlertText[1]);
    }

    private static void PtrEngineStatusNoticeListener(String newEngineStatus) {
        // Print out engine status: e.g. "idle", "offline", "online", "printing"...
        System.out.printf("Engine Status: %n  %s%n", newEngineStatus);
    }

    private static void PtrDisplayStatusNoticeListener(String[] newDisplayText) {
        // Print display msgs: e.g. "ONLINE" "ETHERNET/PGL/LP+" or "PRINT HEAD UP" "Close Print Head"
        System.out.println("Printer Display: ");
        Arrays.stream(newDisplayText).forEach(txtLine -> System.out.printf("  %s%n", txtLine));
    }

}
