//
//  Ruler.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/6.
//

#ifndef Ruler_h
#define Ruler_h

#import <Foundation/Foundation.h>
#import <UniPRT/IRuler.h>

/**
 * @~english
 * @class Ruler
 * @brief A class for Ruler, inheriting from IRuler.
 * @ingroup Interface
 *
 * This class provides an implementation for measuring and scaling within a 2D plane, typically used for object placement and dimension calculations.
 *
 * @~chinese
 * @class Ruler
 * @brief 继承自 IRuler 的 Ruler 类。
 * @ingroup Interface
 *
 * 此类用于在二维平面中进行测量和缩放，通常用于对象放置和尺寸计算。
 *
 * @~chinese_traditional
 * @class Ruler
 * @brief 繼承自 IRuler 的 Ruler 類。
 * @ingroup Interface
 *
 * 此類用於在二維平面中進行測量和縮放，通常用於對象放置和尺寸計算。
 */
@interface Ruler : NSObject <IRuler>
@property (nonatomic) ScaleEnum scale;

- (instancetype)initWithScale:(ScaleEnum)scale;
@end


#endif /* Ruler_h */
