package com.test.UniPRTSdk;

import com.UniPRT.Sdk.Comm.TcpConnection;
import java.io.*;

public class commTcpSnippet {
    public static void test() {
        String prtIp = "127.0.0.1";
        sendPrintFile(prtIp);     // send file over default printer data port
        sendPrintString(prtIp);   // send print data over default printer data port
    }

    public static void sendPrintFile(String ipAddress) {
        String fileName = "C:\\testFiles\\Hello.pgl";
        int defaultDataPort = TcpConnection.DEFAULT_DATA_PORT;

        TcpConnection ptrTcpComm = new TcpConnection(ipAddress, defaultDataPort); // sending through default data port

        try {
            ptrTcpComm.Open();
            if (new File(fileName).exists()) {
                try (InputStream binReader = new BufferedInputStream(new FileInputStream(fileName))) {
                    System.out.println("Sending \"" + fileName + "\" to printer");

                    byte[] buffer = new byte[1024];
                    while ((binReader.read(buffer)) != -1) {
                        ptrTcpComm.Write(buffer);
                    }
                }
            } else {
                System.out.println("File \"" + fileName + "\" not found");
            }
        } catch (Exception e) {
            System.out.println("Exception Msg: " + e.getMessage());
        } finally {
            ptrTcpComm.Close();
        }
    }

    public static void sendPrintString(String ipAddress) {
        String dataToPrint =
                "~CREATE;C39;72\n" +
                        "SCALE;DOT\n" +
                        "PAGE;30;40\n" +
                        "ALPHA\n" +
                        "C10;1;33;0;0;@HELLO@\n" +
                        "C16;54;37;0;0;@*World*@\n" +
                        "STOP\n" +
                        "BARCODE\n" +
                        "C128C;XRD3:3:6:6:9:9:12:12;H6;10;32\n" +
                        "@World@\n" +
                        "STOP\n" +
                        "END\n" +
                        "~EXECUTE;C39\n" +
                        "~NORMAL\n";

        int defaultDataPort = TcpConnection.DEFAULT_DATA_PORT;

        TcpConnection ptrTcpComm = new TcpConnection(ipAddress, defaultDataPort); // sending through default data port

        try {
            ptrTcpComm.Open();
            if (ptrTcpComm.Connected()) {
                byte[] outBytes = dataToPrint.getBytes("US-ASCII");
                ptrTcpComm.Write(outBytes);
            } else {
                System.out.println("Not connected to printer");
            }
        } catch (Exception e) {
            System.out.println("Exception Msg: " + e.getMessage());
        } finally {
            ptrTcpComm.Close();
        }
    }
}
