//
//  PglAztecBarcode.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/24.
//

#ifndef PglAztecBarcode_h
#define PglAztecBarcode_h

#import <Foundation/Foundation.h>

#import <UniPRT/AAztecBarcode.h>
#import <UniPRT/IPoint.h>
#import <UniPRT/PrintPlane.h>
#import <UniPRT/PglCmd.h>
#import <UniPRT/PglTranslate.h>
#import <UniPRT/PGL.h>


/**
 * \~English
 * @class PglAztecBarcode
 * @brief A class representing an Aztec barcode.
 *
 * This class inherits from AAztecBarcode and provides functionality for initializing and describing Aztec barcodes.
 *
 * @ingroup PGL
 *
 * \~Chinese
 * @class PglAztecBarcode
 * @brief 表示Aztec条形码的类。
 *
 * 该类继承自AAztecBarcode，并提供了初始化和描述Aztec条形码的功能。
 *
 * @ingroup PGL
 *
 * \~Chinese-Traditional
 * @class PglAztecBarcode
 * @brief 表示Aztec條碼的類。
 *
 * 該類繼承自AAztecBarcode，並提供了初始化和描述Aztec條碼的功能。
 *
 * @ingroup PGL
 */
@interface PglAztecBarcode : AAztecBarcode

/**
 * \~English
 * @brief Initializes a new instance of the PglAztecBarcode class.
 *
 * @return A new instance of PglAztecBarcode.
 *
 * \~Chinese
 * @brief 初始化PglAztecBarcode类的新实例。
 *
 * @return PglAztecBarcode的新实例。
 *
 * \~Chinese-Traditional
 * @brief 初始化PglAztecBarcode類的新實例。
 *
 * @return PglAztecBarcode的新實例。
 */
- (instancetype)init;

/**
 * \~English
 * @brief Initializes a new instance of the PglAztecBarcode class with the specified start point and data.
 *
 * @param start The starting point of the barcode.
 * @param data The data to be encoded in the barcode.
 * @return A new instance of PglAztecBarcode.
 *
 * \~Chinese
 * @brief 使用指定的起始点和数据初始化PglAztecBarcode类的新实例。
 *
 * @param start 条形码的起始点。
 * @param data 要编码到条形码中的数据。
 * @return PglAztecBarcode的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的起始點和數據初始化PglAztecBarcode類的新實例。
 *
 * @param start 條碼的起始點。
 * @param data 要編碼到條碼中的數據。
 * @return PglAztecBarcode的新實例。
 */
- (instancetype)initWithStart:(id<IPoint>)start data:(NSString *)data;

/**
 * \~English
 * @brief Returns the string that can be sent to printer.
 *
 * @return A string description of the PglAztecBarcode instance.
 *
 * \~Chinese
 * @brief 返回可以发送到打印机的字符串。
 *
 * @return PglAztecBarcode实例的字符串描述。
 *
 * \~Chinese-Traditional
 * @brief 返回可以發送到打印機的字符串。
 *
 * @return PglAztecBarcode實例的字符串描述。
 */
- (NSString *)description;

@end

#endif /* PglAztecBarcode_h */
