//
//  _PglLine.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/24.
//

#ifndef _PglLine_h
#define _PglLine_h

#import <Foundation/Foundation.h>

#import <UniPRT/ALine.h>
#import <UniPRT/IPoint.h>
#import <UniPRT/PrintPlane.h>
#import <UniPRT/Defaults.h>
#import <UniPRT/Point.h>
#import <UniPRT/PglLine.h>

/**
 * \~English
 * @class _PglLine
 * @brief A class representing a line shape.
 *
 * This class inherits from ALine and provides functionality for initializing and describing a line.
 *
 * @ingroup PGL
 *
 * \~Chinese
 * @class _PglLine
 * @brief 表示一条线形状的类。
 *
 * 该类继承自 ALine，并提供了初始化和描述线条的功能。
 *
 * @ingroup PGL
 *
 * \~Chinese-Traditional
 * @class _PglLine
 * @brief 表示一條線形狀的類。
 *
 * 該類繼承自 ALine，並提供了初始化和描述線條的功能。
 *
 * @ingroup PGL
 */
@interface _PglLine : ALine

/**
 * \~English
 * @brief Initializes a new instance of the _PglLine class with specified start and end points and line thickness.
 *
 * @param start The starting point of the line.
 * @param end The ending point of the line.
 * @param lineThickness The thickness of the line.
 * @return A new instance of _PglLine.
 *
 * \~Chinese
 * @brief 使用指定的起始点、结束点和线条厚度初始化 _PglLine 类的新实例。
 *
 * @param start 线条的起始点。
 * @param end 线条的结束点。
 * @param lineThickness 线条的厚度。
 * @return _PglLine 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的起始點、結束點和線條厚度初始化 _PglLine 類的新實例。
 *
 * @param start 線條的起始點。
 * @param end 線條的結束點。
 * @param lineThickness 線條的厚度。
 * @return _PglLine 的新實例。
 */
- (instancetype)initWithStart:(id<IPoint>)start end:(id<IPoint>)end lineThickness:(float)lineThickness;

/**
 * \~English
 * @brief Initializes a new instance of the _PglLine class with specified start and end coordinates and line thickness.
 *
 * @param xStart The x-coordinate of the starting point.
 * @param yStart The y-coordinate of the starting point.
 * @param xEnd The x-coordinate of the ending point.
 * @param yEnd The y-coordinate of the ending point.
 * @param lineThickness The thickness of the line.
 * @return A new instance of _PglLine.
 *
 * \~Chinese
 * @brief 使用指定的起始坐标、结束坐标和线条厚度初始化 _PglLine 类的新实例。
 *
 * @param xStart 起始点的 x 坐标。
 * @param yStart 起始点的 y 坐标。
 * @param xEnd 结束点的 x 坐标。
 * @param yEnd 结束点的 y 坐标。
 * @param lineThickness 线条的厚度。
 * @return _PglLine 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的起始坐標、結束坐標和線條厚度初始化 _PglLine 類的新實例。
 *
 * @param xStart 起始點的 x 坐標。
 * @param yStart 起始點的 y 坐標。
 * @param xEnd 結束點的 x 坐標。
 * @param yEnd 結束點的 y 坐標。
 * @param lineThickness 線條的厚度。
 * @return _PglLine 的新實例。
 */
- (instancetype)initWithXStart:(float)xStart yStart:(float)yStart xEnd:(float)xEnd yEnd:(float)yEnd lineThickness:(float)lineThickness;

/**
 * \~English
 * @brief Returns a string that can be sent to the printer.
 *
 * This method generates a string representation of the _PglLine instance that
 * is formatted and ready to be sent to a printer. The string includes all the
 * necessary commands and data required for printing.
 *
 * @return A string description of the _PglLine instance.
 *
 * \~Chinese
 * @brief 返回可以发送到打印机的字符串。
 *
 * 该方法生成 _PglLine 实例的字符串表示形式，
 * 格式化并准备好发送到打印机。字符串包括打印所需的所有命令和数据。
 *
 * @return _PglLine 实例的字符串描述。
 *
 * \~Chinese-Traditional
 * @brief 返回可以發送到打印機的字符串。
 *
 * 該方法生成 _PglLine 實例的字符串表示形式，
 * 格式化並準備好發送到打印機。字符串包括打印所需的所有命令和數據。
 *
 * @return _PglLine 實例的字符串描述。
 */
- (NSString *)description;

@end

#endif /* _PglLine_h */
