//
//  CancellationToken.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/3.
//

#ifndef CancellationToken_h
#define CancellationToken_h


#endif /* CancellationToken_h */

#import <Foundation/Foundation.h>

/**
 * @class CancellationToken
 * @brief A class for managing cancellation tokens used to cancel asynchronous operations.
 * @ingroup JSONMng
 */
@interface CancellationToken : NSObject

/**
 * @brief Requests cancellation of the operation associated with this token.
 */
- (void)cancel;

/**
 * @brief Checks if cancellation has been requested.
 *
 * @return YES if cancellation has been requested, NO otherwise.
 */
- (BOOL)isCancellationRequested;

/**
 * @brief Waits for the cancellation to be requested.
 */
- (void)waitForCancellation;

/**
 * @brief Checks if the operation associated with this token is still running.
 *
 * @return YES if the operation is running, NO otherwise.
 */
- (BOOL)isRunning;

/**
 * @brief Requests cancellation and waits for the operation to complete.
 */
- (void)cancelAndWait;

@end
