//
//  OdvMonitor.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/14.
//

#ifndef OdvMonitor_h
#define OdvMonitor_h


#endif /* OdvMonitor_h */
#import <Foundation/Foundation.h>
#import <AutoIdSDK/TcpComm.h>
#import <AutoIdSDK/JsonComm.h>
#import <AutoIdSDK/OdvReport.h>

/**
 * @class OdvMonitor
 * @brief A class for monitoring Optical Disc Verification (ODV) reports.
 * @ingroup Monitor
 */
@interface OdvMonitor : NSObject

/**
 * @brief A constant ID that the class does not care about.
 */
@property (nonatomic, strong) NSString *DONT_CARE_ID;

/**
 * @brief A flag indicating whether ODV report listening is enabled.
 */
@property (nonatomic, assign) BOOL odvReportListening;

/**
 * @brief The thread for listening to ODV reports.
 */
@property (nonatomic, strong) NSThread *listenerThread;

/**
 * @brief The synchronization context, assumed to be an NSObject or similar.
 */
@property (nonatomic, strong) id syncContext;

/**
 * @brief The descriptor managed by the monitor.
 */
@property (nonatomic, strong) NSString *managedDescriptor;

/**
 * @brief Initializes a new instance with the given TCP communication object.
 *
 * @param connection The TCP communication object.
 * @return An initialized instance of OdvMonitor, or nil if the object could not be created.
 */
- (instancetype)initWithTcpComm:(TcpComm *)connection;

/**
 * @brief Initializes a new instance with the given JSON communication object.
 *
 * @param mgmtComm The JSON communication object.
 * @return An initialized instance of OdvMonitor, or nil if the object could not be created.
 */
- (instancetype)initWithJsonComm:(JsonComm *)mgmtComm;

/**
 * @brief Initializes a new instance with the given communication descriptor.
 *
 * @param commDescriptor The communication descriptor.
 * @return An initialized instance of OdvMonitor, or nil if the object could not be created.
 */
- (instancetype)initWithCommDescriptor:(NSString *)commDescriptor;

/**
 * @brief Sets whether ODV report listening is enabled.
 *
 * @param value YES to enable listening, NO to disable.
 */
- (void)SetOdvReportListening:(BOOL)value;

/**
 * @typedef OdvReportCallback
 * @brief A callback type for ODV report changes.
 *
 * @param report The new ODV report.
 */
typedef void (^OdvReportCallback)(OdvReport *report);

/**
 * @brief The callback for ODV report changes.
 */
@property (nonatomic, copy) OdvReportCallback odvReportCallback;

@end

