//
//  PglQRBarcode.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/27.
//

#ifndef PglQRBarcode_h
#define PglQRBarcode_h

#import <Foundation/Foundation.h>
#import <UniPRT/AQRBarcode.h>
#import <UniPRT/IPoint.h>
#import <UniPRT/QRCodeManualEncodingEnum.h>

/**
 * \~English
 * @class PglQRBarcode
 * @brief A class representing a QR code barcode.
 *
 * This class inherits from AQRBarcode and provides functionality for initializing and describing QR code barcodes.
 *
 * @ingroup PGL
 *
 * \~Chinese
 * @class PglQRBarcode
 * @brief 表示一个 QR 码条形码的类。
 *
 * 该类继承自 AQRBarcode，并提供了初始化和描述 QR 码条形码的功能。
 *
 * @ingroup PGL
 *
 * \~Chinese-Traditional
 * @class PglQRBarcode
 * @brief 表示一個 QR 碼條形碼的類。
 *
 * 該類繼承自 AQRBarcode，並提供了初始化和描述 QR 碼條形碼的功能。
 *
 * @ingroup PGL
 */
@interface PglQRBarcode : AQRBarcode

/**
 * \~English
 * @brief Initializes a new instance of the PglQRBarcode class with the specified start point and data.
 *
 * @param start The starting point of the QR code.
 * @param data The data to be encoded in the QR code.
 * @return A new instance of PglQRBarcode.
 *
 * \~Chinese
 * @brief 使用指定的起始点和数据初始化 PglQRBarcode 类的新实例。
 *
 * @param start QR 码的起始点。
 * @param data 要在 QR 码中编码的数据。
 * @return PglQRBarcode 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的起始點和數據初始化 PglQRBarcode 類的新實例。
 *
 * @param start QR 碼的起始點。
 * @param data 要在 QR 碼中編碼的數據。
 * @return PglQRBarcode 的新實例。
 */
- (instancetype)initWithStart:(id<IPoint>)start data:(NSString *)data;

/**
 * \~English
 * @brief Initializes a new instance of the PglQRBarcode class with the specified start point and manually encoded data.
 *
 * @param start The starting point of the QR code.
 * @param dataManuallyEncoded An array of manually encoded data points for the QR code.
 * @return A new instance of PglQRBarcode.
 *
 * \~Chinese
 * @brief 使用指定的起始点和手动编码的数据初始化 PglQRBarcode 类的新实例。
 *
 * @param start QR 码的起始点。
 * @param dataManuallyEncoded 手动编码的 QR 码数据点数组。
 * @return PglQRBarcode 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的起始點和手動編碼的數據初始化 PglQRBarcode 類的新實例。
 *
 * @param start QR 碼的起始點。
 * @param dataManuallyEncoded 手動編碼的 QR 碼數據點數組。
 * @return PglQRBarcode 的新實例。
 */
- (instancetype)initWithStart:(id<IPoint>)start dataManuallyEncoded:(NSArray<NSValue *> *)dataManuallyEncoded;

/**
 * \~English
 * @brief Returns a string that can be sent to the printer.
 *
 * This method generates a string representation of the PglQRBarcode instance that
 * is formatted and ready to be sent to a printer. The string includes all the
 * necessary commands and data required for printing.
 *
 * @return A string description of the PglQRBarcode instance.
 *
 * \~Chinese
 * @brief 返回可以发送到打印机的字符串。
 *
 * 该方法生成 PglQRBarcode 实例的字符串表示形式，
 * 格式化并准备好发送到打印机。字符串包括打印所需的所有命令和数据。
 *
 * @return PglQRBarcode 实例的字符串描述。
 *
 * \~Chinese-Traditional
 * @brief 返回可以發送到打印機的字符串。
 *
 * 該方法生成 PglQRBarcode 實例的字符串表示形式，
 * 格式化並準備好發送到打印機。字符串包括打印所需的所有命令和數據。
 *
 * @return PglQRBarcode 實例的字符串描述。
 */
- (NSString *)description;

@end

#endif /* PglQRBarcode_h */
