//
//  AztecBarcode.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/15.
//

#ifndef AztecBarcode_h
#define AztecBarcode_h

#import <Foundation/Foundation.h>

#import <UniPRT/AAztecBarcode.h>
#import <UniPRT/PrintPlane.h>
#import <UniPRT/TsplCmd.h>
#import <UniPRT/TSPL.h>
#import <UniPRT/Translate.h>

/**
 * \~English
 * @class AztecBarcode
 * @brief A class representing an Aztec barcode for TSPL.
 *
 * This class inherits from AAztecBarcode and provides functionality for initializing and describing Aztec barcodes in TSPL.
 *
 * @ingroup TSPL
 *
 * \~Chinese
 * @class AztecBarcode
 * @brief 表示用于 TSPL 的 Aztec 条码的类。
 *
 * 该类继承自 AAztecBarcode，并提供了在 TSPL 中初始化和描述 Aztec 条码的功能。
 *
 * @ingroup TSPL
 *
 * \~Chinese-Traditional
 * @class AztecBarcode
 * @brief 表示用於 TSPL 的 Aztec 條碼的類。
 *
 * 該類繼承自 AAztecBarcode，並提供了在 TSPL 中初始化和描述 Aztec 條碼的功能。
 *
 * @ingroup TSPL
 */
@interface AztecBarcode : AAztecBarcode

/**
 * \~English
 * @brief Initializes a new instance of the AztecBarcode class.
 *
 * @return A new instance of AztecBarcode.
 *
 * \~Chinese
 * @brief 初始化 AztecBarcode 类的新实例。
 *
 * @return AztecBarcode 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 初始化 AztecBarcode 類的新實例。
 *
 * @return AztecBarcode 的新實例。
 */
- (instancetype)init;

/**
 * \~English
 * @brief Initializes a new instance of the AztecBarcode class with the specified start point and data.
 *
 * @param start The starting point of the barcode.
 * @param data The data to be encoded in the barcode.
 * @return A new instance of AztecBarcode.
 *
 * \~Chinese
 * @brief 使用指定的起始点和数据初始化 AztecBarcode 类的新实例。
 *
 * @param start 条码的起始点。
 * @param data 要在条码中编码的数据。
 * @return AztecBarcode 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的起始點和數據初始化 AztecBarcode 類的新實例。
 *
 * @param start 條碼的起始點。
 * @param data 要在條碼中編碼的數據。
 * @return AztecBarcode 的新實例。
 */
- (instancetype)initWithStart:(id<IPoint>)start data:(NSString *)data;

/**
 * \~English
 * @brief Returns a string that can be sent to the printer.
 *
 * This method generates a string representation of the AztecBarcode instance that
 * is formatted and ready to be sent to a printer. The string includes all the
 * necessary commands and data required for printing in TSPL.
 *
 * @return A string description of the AztecBarcode instance.
 *
 * \~Chinese
 * @brief 返回可以发送到打印机的字符串。
 *
 * 该方法生成 AztecBarcode 实例的字符串表示形式，
 * 格式化并准备好发送到打印机。字符串包括在 TSPL 中打印所需的所有命令和数据。
 *
 * @return AztecBarcode 实例的字符串描述。
 *
 * \~Chinese-Traditional
 * @brief 返回可以發送到打印機的字符串。
 *
 * 該方法生成 AztecBarcode 實例的字符串表示形式，
 * 格式化並準備好發送到打印機。字符串包括在 TSPL 中打印所需的所有命令和數據。
 *
 * @return AztecBarcode 實例的字符串描述。
 */
- (NSString *)description;

@end

#endif /* AztecBarcode_h */
