//
//  CellRect.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef CellRect_h
#define CellRect_h


#import <UniPRT/ACellSquare.h>
#import <UniPRT/ICellRect.h>

/**
 * @~english
 * @class CellRect
 * @brief A class for CellRect, conforming to the ICellRect protocol.
 * @ingroup Interface
 *
 * @~chinese
 * @class CellRect
 * @brief 遵循 ICellRect 协议的 CellRect 类。
 * @ingroup Interface
 *
 * @~Chinese-Traditional
 * @class CellRect
 * @brief 遵循 ICellRect 協議的 CellRect 類。
 * @ingroup Interface
 */
@interface CellRect : ACellSquare <ICellRect>

@property (nonatomic, assign) float ydim;

- (instancetype)init;
- (instancetype)initWithXDim:(float)xdim yDim:(float)ydim ruler:(id<IRuler>)ruler;

@end

#endif /* CellRect_h */
