#import "ViewController.h"
#define MAX_INPUT_MSG_CAPACITY 20
#define MAX_WAIT_TIME_SECS 15
@import UniPRT;

@interface ViewController ()
@property (strong) TcpComm *tcpComm;
@property (nonatomic, strong) UITextField *ipTextField;
@property (nonatomic, strong) UITextView *resultTextView;
@property (nonatomic, strong) UIButton *openButton;
@property (nonatomic, strong) UIButton *connectCloseButton;
@property (nonatomic, strong) UIButton *connectMgmtCommTestButton;
@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
        
    // Create and configure IP address text field
    self.ipTextField = [[UITextField alloc] initWithFrame:CGRectMake(20, 50, 200, 30)];
    self.ipTextField.placeholder = @"Enter IP Address";
    self.ipTextField.borderStyle = UITextBorderStyleRoundedRect;
    [self.view addSubview:self.ipTextField];
    self.ipTextField.text = @"10.0.10.180";
    
    // Create and configure result text view
    self.resultTextView = [[UITextView alloc] initWithFrame:CGRectMake(20, 150, 300, 200)];
    self.resultTextView.editable = NO;
    self.resultTextView.scrollEnabled = YES;
    self.resultTextView.layer.borderWidth = 1.0;
    self.resultTextView.layer.borderColor = [[UIColor blackColor] CGColor];
    [self.view addSubview:self.resultTextView];

    // Create and configure buttons
    self.openButton = [self createButtonWithTitle:@"Open" frame:CGRectMake(20, 370, 80, 30)];
    self.openButton.backgroundColor = [UIColor redColor];
    [self.openButton addTarget:self action:@selector(openButtonPressed) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:self.openButton];
    
    self.connectCloseButton = [self createButtonWithTitle:@"Connect" frame:CGRectMake(20, 420, 120, 30)];
    self.connectCloseButton.backgroundColor = [UIColor redColor];
    [self.connectCloseButton addTarget:self action:@selector(connectCloseButtonPressed) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:self.connectCloseButton];
    
    self.connectMgmtCommTestButton = [self createButtonWithTitle:@"MgmtCommTest" frame:CGRectMake(20, 470, 300, 30)];
    self.connectMgmtCommTestButton.backgroundColor = [UIColor redColor];
    [self.connectMgmtCommTestButton addTarget:self action:@selector(MgmtCommTestButtonPressed) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:self.connectMgmtCommTestButton];
}

- (UIButton *)createButtonWithTitle:(NSString *)title frame:(CGRect)frame {
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    button.frame = frame;
    [button setTitle:title forState:UIControlStateNormal];
    return button;
}

- (void)openButtonPressed {
    [self.tcpComm open];
}

- (void)connectCloseButtonPressed {
    NSString *currentTitle = [self.connectCloseButton titleForState:UIControlStateNormal];
    
    if ([currentTitle isEqualToString:@"Connect"]) {
        NSString *ipAddress = self.ipTextField.text;
        self.tcpComm = [[TcpComm alloc] initWithIPAddress:ipAddress port:DEFAULT_MGMT_PORT];
        [self.connectCloseButton setTitle:@"Close" forState:UIControlStateNormal];

    } else if ([currentTitle isEqualToString:@"Close"]) {
        [self.tcpComm close];
        [self.connectCloseButton setTitle:@"Connect" forState:UIControlStateNormal];
    }
}

- (void)MgmtCommTestButtonPressed {
    CommType commType = TCP_COMM;
    JsonMessenger *jsonMessenger = [[JsonMessenger alloc] initWithCommToPtr:self.tcpComm iCommTyp:commType maxInputMsgCapacity:MAX_INPUT_MSG_CAPACITY usingDataPort:false];
    
    if (jsonMessenger != nil)
    {
        NSString *command = @"Cfg.Prop";
        NSString *content = @"{\r\n\"all\" : null\r\n}\r\n";
        
        NSLog(@"\nSend to Printer:\n\"Command\": \"%@\"\n\"Content\":\n%@", command, content);
        
        JsonMng *trackNumber = [jsonMessenger sendMsgAndWaitForResponseWithCommand:command content:content maxWaitTimeSecs:MAX_WAIT_TIME_SECS];
        NSString *receivedString = trackNumber.strResponse;
        self.resultTextView.text = receivedString;
    }
}

@end
