//
//  MaxicodeMsg.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/16.
//

#ifndef MaxicodeMsg_h
#define MaxicodeMsg_h

#import <Foundation/Foundation.h>
#import <UniPRT/AMaxicodeMsg.h>

/**
 * \~English
 * @class MaxicodeMsg
 * @brief A class representing a Maxicode message for TSPL.
 *
 * This class inherits from AMaxicodeMsg and provides functionality for initializing and managing Maxicode messages in TSPL.
 *
 * @ingroup TSPL
 *
 * \~Chinese
 * @class MaxicodeMsg
 * @brief 表示用于 TSPL 的 Maxicode 消息的类。
 *
 * 该类继承自 AMaxicodeMsg，并提供了在 TSPL 中初始化和管理 Maxicode 消息的功能。
 *
 * @ingroup TSPL
 *
 * \~Chinese-Traditional
 * @class MaxicodeMsg
 * @brief 表示用於 TSPL 的 Maxicode 消息的類。
 *
 * 該類繼承自 AMaxicodeMsg，並提供了在 TSPL 中初始化和管理 Maxicode 消息的功能。
 *
 * @ingroup TSPL
 */
@interface MaxicodeMsg : AMaxicodeMsg

/**
 * \~English
 * @brief Initializes a new instance of the MaxicodeMsg class with the specified mode, primary message, and remaining message.
 *
 * @param mode The mode of the Maxicode.
 * @param primaryMsg The primary message to be encoded.
 * @param remainingMsg The remaining message to be encoded.
 * @return A new instance of MaxicodeMsg.
 *
 * \~Chinese
 * @brief 使用指定的模式、主要消息和剩余消息初始化 MaxicodeMsg 类的新实例。
 *
 * @param mode Maxicode 的模式。
 * @param primaryMsg 要编码的主要消息。
 * @param remainingMsg 要编码的剩余消息。
 * @return MaxicodeMsg 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的模式、主要消息和剩餘消息初始化 MaxicodeMsg 類的新實例。
 *
 * @param mode Maxicode 的模式。
 * @param primaryMsg 要編碼的主要消息。
 * @param remainingMsg 要編碼的剩餘消息。
 * @return MaxicodeMsg 的新實例。
 */
- (instancetype)initWithMode:(MaxicodeModeEnum)mode primaryMsg:(NSString *)primaryMsg remainingMsg:(NSString *)remainingMsg;

@end

#endif /* MaxicodeMsg_h */

