//
//  QRCodeManualEncodingEnum.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef QRCodeManualEncodingEnum_h
#define QRCodeManualEncodingEnum_h

// QRCodeManualEncodingEnum.h
#import <Foundation/Foundation.h>

/**
 * \~English
 * @class QRCodeManualEncodingEnum
 * @brief QR Code data can be stored using different encoding types which affect the storage capacity of the barcode.
 *
 * In order to optimize barcode data capacity, it may sometimes be desirable to manually encode different data types to match the type of data being stored in the QR Barcode.
 *
 * For example, Numeric data (numbers only) can be stored more efficiently than other data types, and if there is a long string of numbers, it may be more efficient to store the data in Numeric format.
 *
 * @ingroup Interface
 *
 * | Value                           | Description                        |
 * |---------------------------------|------------------------------------|
 * | QRCodeManualEncodingNumeric     | Numbers only.                      |
 * | QRCodeManualEncodingAlphaNumeric| Numbers and letters.               |
 * | QRCodeManualEncodingBinary      | Byte/binary.                       |
 * | QRCodeManualEncodingKanji       | Kanji Data.                        |
 *
 * \~Chinese
 * @class QRCodeManualEncodingEnum
 * @brief QR码数据可以使用不同的编码类型存储，这些编码类型会影响条形码的存储容量。
 *
 * 为了优化条形码数据容量，有时可能需要手动编码不同的数据类型以匹配存储在QR条形码中的数据类型。
 *
 * 例如，数值数据（仅数字）可以比其他数据类型更有效地存储，如果有一长串数字，则以数值格式存储数据可能更有效。
 *
 * @ingroup Interface
 *
 * | 值                            | 描述                             |
 * |------------------------------|--------------------------------|
 * | QRCodeManualEncodingNumeric  | 仅数字。                        |
 * | QRCodeManualEncodingAlphaNumeric| 数字和字母。                    |
 * | QRCodeManualEncodingBinary   | 字节/二进制。                    |
 * | QRCodeManualEncodingKanji    | 汉字数据。                       |
 *
 * \~Chinese-Traditional
 * @class QRCodeManualEncodingEnum
 * @brief QR碼數據可以使用不同的編碼類型存儲，這些編碼類型會影響條形碼的存儲容量。
 *
 * 為了優化條形碼數據容量，有時可能需要手動編碼不同的數據類型以匹配存儲在QR條形碼中的數據類型。
 *
 * 例如，數值數據（僅數字）可以比其他數據類型更有效地存儲，如果有一長串數字，則以數值格式存儲數據可能更有效。
 *
 * @ingroup Interface
 *
 * | 值                            | 描述                             |
 * |------------------------------|--------------------------------|
 * | QRCodeManualEncodingNumeric  | 僅數字。                        |
 * | QRCodeManualEncodingAlphaNumeric| 數字和字母。                    |
 * | QRCodeManualEncodingBinary   | 字節/二進制。                    |
 * | QRCodeManualEncodingKanji    | 漢字數據。                       |
 */
typedef NS_ENUM(NSUInteger, QRCodeManualEncodingEnum) {
    QRCodeManualEncodingNumeric,           ///< \~English Numbers only. \~Chinese 仅数字。 \~Chinese-Traditional 僅數字。
    QRCodeManualEncodingAlphaNumeric,      ///< \~English Numbers and letters. \~Chinese 数字和字母。 \~Chinese-Traditional 數字和字母。
    QRCodeManualEncodingBinary,            ///< \~English Byte/binary. \~Chinese 字节/二进制。 \~Chinese-Traditional 字節/二進制。
    QRCodeManualEncodingKanji              ///< \~English Kanji Data. \~Chinese 汉字数据。 \~Chinese-Traditional 漢字數據。
};

#endif /* QRCodeManualEncodingEnum_h */
