//
//  AAztecBarcode.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef AAztecBarcode_h
#define AAztecBarcode_h

#import <Foundation/Foundation.h>

#import <AutoIdSDK/ABarcode2D.h>
#import <AutoIdSDK/ISquareCell.h>
#import <AutoIdSDK/AztecCodeTypeEnum.h>

@interface AAztecBarcode : ABarcode2D <ISquareCell>

@property (nonatomic, strong) id<ICellSquare> cellSize;
@property (nonatomic, assign) AztecCodeTypeEnum type;
@property (nonatomic, assign) int layers;
@property (nonatomic, assign) int fixedErrCorrection;

- (instancetype)init;
- (instancetype)initWithStart:(id<IPoint>)start data:(NSString *)data NS_DESIGNATED_INITIALIZER;
// Abstract-like methods that subclasses need to implement or handle
- (int)getLayersWithinRange;
- (BOOL)hasLayers;
- (int)getErrCorrectionPercent;

@end

#endif /* AAztecBarcode_h */
