//
//  JsonMessenger.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/8.
//

#ifndef JsonMessenger_h
#define JsonMessenger_h


#endif /* JsonMessenger_h */

#import <Foundation/Foundation.h>
#import <AutoIdSDK/JsonComm.h>
#import <AutoIdSDK/JsonMng.h>
#import <AutoIdSDK/TcpComm.h>
#import <AutoIdSDK/JsonCommController.h>


// Forward declarations
@class TcpComm;
@class BtComm;
@class UsbComm;
@class JsonMng;
@class JsonComm;

@interface JsonMessenger : NSObject {
    BOOL _usingDataPort;
    BOOL _disposed;
    // JsonComm _MgmtComm; // Assuming JsonComm is an Objective-C class you have defined.
    TcpComm *_tcpComm;
    JsonComm *_MgmtComm;
    JsonComm *_MgmtCommPtr;
    ImpChannel * _MsgsFromPtr;
    
    // ImpChannel<std::string> _MsgsFromPtr; // This needs to be adapted to an Objective-C equivalent.
    NSString *_myMgmtId;
    long _TrackCount;
    BOOL _sdkManagedComm;
    NSString *_managedDescriptor;
}



- (instancetype)initWithCommToPtr:(AComm *)commToPtr iCommTyp:(CommType)iCommTyp maxInputMsgCapacity:(int)maxInputMsgCapacity usingDataPort:(BOOL)usingDataPort;
- (NSString *)sendMsgWithCommand:(NSString *)command content:(NSString *)content trackNo:(NSString *)trackNo;
- (JsonMng *)sendMsgAndWaitForResponseWithCommand:(NSString *)command content:(NSString *)content maxWaitTimeSecs:(int)maxWaitTimeSecs;
- (JsonMng *)readNextMsg;
- (void)sendMsgRawWithDataToSend:(NSString *)dataToSend;
//- (int)unreadMsgCount;
- (void)dispose;

@end
