//
//  JsonStringTokenizer.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/2.
//

#ifndef JsonStringTokenizer_h
#define JsonStringTokenizer_h


#endif /* JsonStringTokenizer_h */

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface JsonStringTokenizer : NSObject

+ (BOOL)hasKey:(NSString *)key inJsonString:(NSString *)jsonStr;
+ (BOOL)hasKeyAtPath:(NSString *)keyPath inJsonString:(NSString *)jsonStr;
+ (NSString *)getKeyValue:(NSString *)key fromJsonString:(NSString *)jsonStr;
+ (NSString *)getKeyValueAtPath:(NSString *)keyPath fromJsonString:(NSString *)jsonStr;
+ (NSDictionary<NSString *, NSString *> *)getKeyValuePairsFromElementList:(NSString *)elemName inJsonData:(NSString *)jsonData;
+ (BOOL)isSolicitedMessageInJson:(NSString *)msgStr;
+ (BOOL)isCommandSuccessInJson:(NSString *)msgStr;
+ (NSString *)getMessageIdFromJson:(NSString *)msgStr;
+ (NSString *)getExpectedMessageIdOnResponseFromJson:(NSString *)msgStr;

@end

NS_ASSUME_NONNULL_END
