//
//  PGL.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/23.
//

#ifndef PGL_h
#define PGL_h

#import <Foundation/Foundation.h>

extern const float PGLAlphaExpansionMin;
extern const float PGLAlphaExpansionMax;
extern const float PGLTwoByteExpansionMin;
extern const float PGLTwoByteExpansionMax;
extern NSString *const PGLDelimeterSFCC;
extern const char PGLDataFrameChar;
extern NSString *const PGLDelimeterParams;
extern NSString *const PGLLineTerminator;
extern const char PGLDataFrameRestrictedChar;

typedef NS_ENUM(NSInteger, PGL_SCALE_DOT) {
    PGL_SCALE_DOT_DFLT_HORZ_DPI = 300,
    PGL_SCALE_DOT_DFLT_VERT_DPI = 300
};

typedef NS_ENUM(NSInteger, PGL_SCALE_CHAR) {
    PGLScaleCharDFLTCPI = 6,
    PGLScaleCharDFLTLPI = 10
};

typedef NS_ENUM(NSInteger, PGLScaleUnits) {
    PGLScaleUnitsDOT,
    PGLScaleUnitsCHAR
};

typedef NS_ENUM(NSInteger, PGLRfidFormat) {
    PGLRfidFormatInvalid,
    PGLRfidFormatBinary,
    PGLRfidFormatDecimal,
    PGLRfidFormatString,
    PGLRfidFormatHex
};

typedef NS_ENUM(NSInteger, PGLRfidMemBlock) {
    PGLRfidMemBlockInvalid,
    PGLRfidMemBlockEPC,
    PGLRfidMemBlockTID,
    PGLRfidMemBlockUSR,
    PGLRfidMemBlockACS,
    PGLRfidMemBlockKIL,
    PGLRfidMemBlockPC,
    PGLRfidMemBlockRSV
};

typedef NS_ENUM(NSInteger, PGLRotation) {
    PGLRotationNone,
    PGLRotationClockwise,
    PGLRotationCounterClockwise,
    PGLRotationInverted
};

typedef NS_ENUM(NSInteger, PGLAlignEnum) {
    PGLAlignEnumNone,
    PGLAlignEnumLeft,
    PGLAlignEnumCenter,
    PGLAlignEnumRight
};

typedef NS_ENUM(NSInteger, PGLBarcodeType1D) {
    PGLBarcodeType1DNotDefined,
    PGLBarcodeType1DCode39,
    PGLBarcodeType1DCode128A,
    PGLBarcodeType1DCode128B,
    PGLBarcodeType1DCode128C,
    PGLBarcodeType1DEAN13,
    PGLBarcodeType1DEAN8,
    PGLBarcodeType1DUPCA,
    PGLBarcodeType1DI2of5,
    PGLBarcodeType1DCODABAR,
    PGLBarcodeType1DGS128,
    PGLBarcodeType1DCode93
};

typedef NS_ENUM(NSInteger, PGLBarcodeType2D) {
    PGLBarcodeType2DNotDefined,
    PGLBarcodeType2DMAXICODE,
    PGLBarcodeType2DQR,
    PGLBarcodeType2DPDF417,
    PGLBarcodeType2DAZTEC,
    PGLBarcodeType2DDMATRIX
};

@interface PGL : NSObject

+ (NSString *)rfidFormatToString:(PGLRfidFormat)format;
+ (NSString *)rfidMemBlockToString:(PGLRfidMemBlock)memBlock;
+ (NSString *)rotationToString:(PGLRotation)rotation;
+ (NSString *)alignmentToString:(PGLAlignEnum)align;
+ (NSString *)barcodeType1DToString:(PGLBarcodeType1D)barcodeType;
+ (NSString *)barcodeType2DToString:(PGLBarcodeType2D)barcodeType;
+ (char)getPrintableDataFrameChar:(NSString *)dataToFrame;
+ (float)igpDotsFromDots:(float)dots dpiResolution:(float)dpiResolution;
+ (int)minLT:(int)ltCheck;

@end

#endif /* PGL_h */
