//
//  PglBarWidths.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/24.
//

#ifndef PglBarWidths_h
#define PglBarWidths_h

#import <Foundation/Foundation.h>

#import <UniPRT/ABarWidths.h>
#import <UniPRT/PrintPlane.h>
#import <UniPRT/Ruler.h>
#import <UniPRT/BarcodeTypeEnum_1D.h>

/**
 * \~English
 * @class PglBarWidths
 * @brief A class representing the widths of bars in barcodes.
 *
 * This class inherits from ABarWidths and provides functionality for initializing bar widths and calculating barcode magnifications.
 *
 * @ingroup PGL
 *
 * \~Chinese
 * @class PglBarWidths
 * @brief 表示条形码条宽的类。
 *
 * 该类继承自ABarWidths，并提供了初始化条宽和计算条形码放大的功能。
 *
 * @ingroup PGL
 *
 * \~Chinese-Traditional
 * @class PglBarWidths
 * @brief 表示條形碼條寬的類。
 *
 * 該類繼承自ABarWidths，並提供了初始化條寬和計算條形碼放大的功能。
 *
 * @ingroup PGL
 */
@interface PglBarWidths : ABarWidths

/**
 * \~English
 * @brief Initializes a new instance of the PglBarWidths class.
 *
 * @return A new instance of PglBarWidths.
 *
 * \~Chinese
 * @brief 初始化PglBarWidths类的新实例。
 *
 * @return PglBarWidths的新实例。
 *
 * \~Chinese-Traditional
 * @brief 初始化PglBarWidths類的新實例。
 *
 * @return PglBarWidths的新實例。
 */
- (instancetype)init;

/**
 * \~English
 * @brief Initializes a new instance of the PglBarWidths class with specified narrow and wide bar widths.
 *
 * @param narrowBar The width of the narrow bar.
 * @param wideBar The width of the wide bar.
 * @return A new instance of PglBarWidths.
 *
 * \~Chinese
 * @brief 使用指定的窄条和宽条宽度初始化PglBarWidths类的新实例。
 *
 * @param narrowBar 窄条的宽度。
 * @param wideBar 宽条的宽度。
 * @return PglBarWidths的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的窄條和寬條寬度初始化PglBarWidths類的新實例。
 *
 * @param narrowBar 窄條的寬度。
 * @param wideBar 寬條的寬度。
 * @return PglBarWidths的新實例。
 */
- (instancetype)initWithNarrowBar:(float)narrowBar wideBar:(float)wideBar;

/**
 * \~English
 * @brief Calculates the magnification of a 1D barcode with the specified type, print plane, and bar widths.
 *
 * @param bcdType The type of the 1D barcode.
 * @param pp The print plane to be used.
 * @param barWidths The bar widths to be used for magnification calculation.
 * @return A string representing the magnification of the 1D barcode.
 *
 * \~Chinese
 * @brief 计算具有指定类型、打印平面和条宽的一维条形码的放大倍数。
 *
 * @param bcdType 一维条形码的类型。
 * @param pp 要使用的打印平面。
 * @param barWidths 用于放大计算的条宽。
 * @return 表示一维条形码放大倍数的字符串。
 *
 * \~Chinese-Traditional
 * @brief 計算具有指定類型、打印平面和條寬的一維條形碼的放大倍數。
 *
 * @param bcdType 一維條形碼的類型。
 * @param pp 要使用的打印平面。
 * @param barWidths 用於放大計算的條寬。
 * @return 表示一維條形碼放大倍數的字符串。
 */
- (NSString *)bcdMagnification1DWithType:(BarcodeTypeEnum1D)bcdType printPlane:(PrintPlane *)pp barWidths:(PglBarWidths *)barWidths;

@end

#endif /* PglBarWidths_h */
