//
//  IRfidBitField.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef IRfidBitField_h
#define IRfidBitField_h

// IRfidBitField.h
#import <Foundation/Foundation.h>

/**
 * @~english
 * @protocol IRfidBitField
 *
 * @brief A protocol defining the interface for RfidWrite classes.
 *
 * @ingroup Interface
 *
 * @~chinese
 * @protocol IRfidBitField
 *
 * @brief 定义 RfidWrite 类接口的协议。
 *
 * @ingroup Interface
 *
 * @~Chinese-Traditional
 * @protocol IRfidBitField
 *
 * @brief 定義 RfidWrite 類接口的協議。
 *
 * @ingroup Interface
 */
@protocol IRfidBitField <NSObject>

/**
 * @~english
 * @brief Optional word offset (16 bits per count) if access to memory that is not the starting position of memory bank.
 *
 * First word starts at offset 0, second word would be at offset 1, and so on.
 *
 * Note:
 *
 * For EPC on Gen 2 tags, the CRC (word 0) and PC Bits (word 1) are not counted as part of the offset.
 *
 * That is, offset 0, refers to the first word after the PC Bits.
 *
 * @~chinese
 * @brief 可选的字偏移量（每个计数16位），如果访问的内存位置不是内存块的起始位置。
 *
 * 第一个字从偏移量0开始，第二个字从偏移量1开始，以此类推。
 *
 * 注意：
 *
 * 对于 Gen 2 标签上的 EPC，CRC（字 0）和 PC 位（字 1）不计算在偏移量内。
 *
 * 也就是说，偏移量 0 是指 PC 位后的第一个字。
 *
 * @~Chinese-Traditional
 * @brief 可選的字偏移量（每個計數16位），如果訪問的內存位置不是內存塊的起始位置。
 *
 * 第一個字從偏移量0開始，第二個字從偏移量1開始，以此類推。
 *
 * 注意：
 *
 * 對於 Gen 2 標籤上的 EPC，CRC（字 0）和 PC 位（字 1）不計算在偏移量內。
 *
 * 也就是說，偏移量 0 是指 PC 位後的第一個字。
 */
@property (nonatomic, assign) int offsetFromStart;

/**
 * @~english
 * @brief Rfid data field. In Most Significant Bits (MSB) to Least Significant Bits (LSB) (left to right). Hex formatted data.
 *
 * @~chinese
 * @brief Rfid 数据字段。从最高有效位（MSB）到最低有效位（LSB）（从左到右）。十六进制格式的数据。
 *
 * @~Chinese-Traditional
 * @brief Rfid 數據字段。從最高有效位（MSB）到最低有效位（LSB）（從左到右）。十六進制格式的數據。
 */
@property (nonatomic, strong) NSString *data;

@end

#endif /* IRfidBitField_h */
