//
//  RfidMemBlockEnum.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef RfidMemBlockEnum_h
#define RfidMemBlockEnum_h

// RfidMemBlockEnum.h
#import <Foundation/Foundation.h>

/**
 * @~english
 * @class RfidMemBlockEnum
 * @brief RFID memory block selection.
 * @ingroup Interface
 *
 * | Value                           | Description                                              |
 * |---------------------------------|----------------------------------------------------------|
 * | RfidMemBlockEnumInvalidMemBlock | For case where need to enforce initialization.           |
 * | RfidMemBlockEnumEPC             | Electronic Product Code.                                 |
 * | RfidMemBlockEnumTID             | Tag Identification. This is typically a read-only field.  |
 * | RfidMemBlockEnumUser            | User memory.                                             |
 * | RfidMemBlockEnumAccessCode      | Access code. Typically 4 bytes.                          |
 * | RfidMemBlockEnumKillCode        | Kill code. Typically 4 bytes.                            |
 * | RfidMemBlockEnumPC              | Protocol Control Word (16 bits) (Gen 2 tags only).       |
 * | RfidMemBlockEnumReserve         | Reserved memory.                                         |
 *
 * @~chinese
 * @class RfidMemBlockEnum
 * @brief RFID存储块选择。
 * @ingroup Interface
 *
 * | 值                               | 描述                                                      |
 * |---------------------------------|----------------------------------------------------------|
 * | RfidMemBlockEnumInvalidMemBlock | 用于需要强制初始化的情况。                                 |
 * | RfidMemBlockEnumEPC             | 电子产品代码。                                             |
 * | RfidMemBlockEnumTID             | 标签识别。通常这是一个只读字段。                           |
 * | RfidMemBlockEnumUser            | 用户内存。                                                 |
 * | RfidMemBlockEnumAccessCode      | 访问代码。通常为4字节。                                    |
 * | RfidMemBlockEnumKillCode        | 杀死代码。通常为4字节。                                    |
 * | RfidMemBlockEnumPC              | 协议控制字（16位）（仅限Gen 2标签）。                       |
 * | RfidMemBlockEnumReserve         | 保留内存。                                                 |
 *
 * @~Chinese-Traditional
 * @class RfidMemBlockEnum
 * @brief RFID存儲塊選擇。
 * @ingroup Interface
 *
 * | 值                               | 描述                                                      |
 * |---------------------------------|----------------------------------------------------------|
 * | RfidMemBlockEnumInvalidMemBlock | 用於需要強制初始化的情況。                                 |
 * | RfidMemBlockEnumEPC             | 電子產品代碼。                                             |
 * | RfidMemBlockEnumTID             | 標籤識別。通常這是一個只讀字段。                           |
 * | RfidMemBlockEnumUser            | 用戶內存。                                                 |
 * | RfidMemBlockEnumAccessCode      | 訪問代碼。通常為4字節。                                    |
 * | RfidMemBlockEnumKillCode        | 殺死代碼。通常為4字節。                                    |
 * | RfidMemBlockEnumPC              | 協議控制字（16位）（僅限Gen 2標籤）。                      |
 * | RfidMemBlockEnumReserve         | 保留內存。                                                 |
 */
typedef NS_ENUM(NSUInteger, RfidMemBlockEnum) {
    RfidMemBlockEnumInvalidMemBlock,
    RfidMemBlockEnumEPC,
    RfidMemBlockEnumTID,
    RfidMemBlockEnumUser,
    RfidMemBlockEnumAccessCode,
    RfidMemBlockEnumKillCode,
    RfidMemBlockEnumPC,
    RfidMemBlockEnumReserve
};

#endif /* RfidMemBlockEnum_h */
