//
//  APglCmd.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/23.
//

#ifndef APglCmd_h
#define APglCmd_h


#import <Foundation/Foundation.h>
#import <AutoIdSDK/IPglCmd.h>


NS_ASSUME_NONNULL_BEGIN

@interface APglCmd : NSObject <IPglCmd>

@property (nonatomic, assign) BOOL useSfcc;
@property (nonatomic, strong) NSString *CMD;
@property (nonatomic, strong) NSString *cmdSuffix;
@property (nonatomic, strong) NSMutableArray<id<IPglParamLine>> *parameterLines;

- (instancetype)init;
- (instancetype)initWithCmd:(NSString *)cmd;
- (instancetype)initWithCmd:(NSString *)cmd cmdSuffix:(NSString *)cmdSuffix;
- (instancetype)initWithUseSfcc:(BOOL)useSfcc cmd:(NSString *)cmd cmdSuffix:(NSString *)cmdSuffix;
- (void)clearParameterLines;
- (id<IPglParamLine>)getNewParameterLineWithStartOfLine:(NSString *)startOfLine endOfLine:(NSString *)endOfLine;
- (NSString *)getAsString;
- (NSString *)description;

@end

NS_ASSUME_NONNULL_END


#endif /* APGLCmd_h */
