//
//  SynchronizationContext.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/11.
//

#ifndef SynchronizationContext_h
#define SynchronizationContext_h


#endif /* SynchronizationContext_h */

#import <Foundation/Foundation.h>

/**
 * @class SynchronizationContext
 * @brief A class for managing synchronization contexts, allowing actions to be posted and executed in a specific context.
 * @ingroup JSONMng
 */
@interface SynchronizationContext : NSObject

/**
 * @brief Posts an action to be executed in the synchronization context.
 *
 * @param action The action to be executed.
 */
- (void)post:(void (^)(void))action;

/**
 * @brief Waits for all posted actions to complete.
 */
- (void)wait;

@end

