//
//  FontSizeUnitsEnum.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef FontSizeUnitsEnum_h
#define FontSizeUnitsEnum_h

#import <Foundation/Foundation.h>

/**
 * \~English
 * @enum FontSizeUnitsEnum
 * @brief Select the font size units for font resizing.
 * @ingroup Interface
 *
 * This enumeration defines the different units for resizing fonts.
 *
 * | Value                           | Description                                              |
 * |---------------------------------|----------------------------------------------------------|
 * | Ruler            | Use the units of the ruler. Ruler units are converted to font points (1/72 inch, ~0.35 mm). |
 * | Points | Use font point. 1 point = 1/72 inch (~0.35 mm).|
 * | Percent            | 0-100 percent expansion/multiplier scaling. 0 or 1 specifies standard font, no scaling. 100% for maximum expansion/multiplier.|
 *
 * \~Chinese
 * @enum FontSizeUnitsEnum
 * @brief 选择用于字体调整的字体大小单位。
 * @ingroup Interface
 *
 * 这个枚举定义了用于调整字体大小的不同单位。
 *
 * | 值                               | 描述                                              |
 * |---------------------------------|----------------------------------------------------------|
 * | Ruler            | 使用标尺的单位。标尺单位转换为字体点（1/72 英寸，约0.35毫米）。 |
 * | Points | 使用字体点。1 点 = 1/72 英寸（约0.35毫米）。|
 * | Percent            | 0-100 百分比扩展/乘数缩放。0 或 1 表示标准字体，无缩放。100% 表示最大扩展/乘数。|
 *
 * \~Chinese-Traditional
 * @enum FontSizeUnitsEnum
 * @brief 選擇用於字體調整的字體大小單位。
 * @ingroup Interface
 *
 * 這個枚舉定義了用於調整字體大小的不同單位。
 *
 * | 值                               | 描述                                              |
 * |---------------------------------|----------------------------------------------------------|
 * | Ruler            | 使用標尺的單位。標尺單位轉換為字體點（1/72 英寸，約0.35毫米）。 |
 * | Points | 使用字體點。1 點 = 1/72 英寸（約0.35毫米）。|
 * | Percent            | 0-100 百分比擴展/乘數縮放。0 或 1 表示標準字體，無縮放。100% 表示最大擴展/乘數。|
 */
typedef NS_ENUM(NSUInteger, FontSizeUnitsEnum) {
    FontSizeUnitsRuler,   // Use the units of the ruler
    FontSizeUnitsPoints,  // Use font point
    FontSizeUnitsPercent  // 0-100 percent expansion/multiplier scaling
};

#endif /* FontSizeUnitsEnum_h */
