//
//  IFontSize.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef IFontSize_h
#define IFontSize_h

// IFontSize.h
#import <Foundation/Foundation.h>
#import <UniPRT/IPair.h>

/**
 * \~English
 * @protocol IFontSize
 * @brief A protocol defining the interface for FontSize classes.
 * @ingroup Interface
 *
 * This protocol extends the IPair protocol, providing an interface for handling font sizes.
 *
 * \~Chinese
 * @protocol IFontSize
 * @brief 定义字体大小类接口的协议。
 * @ingroup Interface
 *
 * 此协议扩展了 IPair 协议，为处理字体大小提供了接口。
 *
 * \~Chinese-Traditional
 * @protocol IFontSize
 * @brief 定義字體大小類接口的協議。
 * @ingroup Interface
 *
 * 此協議擴展了 IPair 協議，為處理字體大小提供了接口。
 */
@protocol IFontSize <IPair>
@end

#endif /* IFontSize_h */
