import Foundation
import UniPRT


func main() {
    let ipAddress = "10.0.10.170"
    let tcpComm = TcpComm(ipAddress: ipAddress, port: UInt(DEFAULT_MGMT_PORT))
    tcpComm?.open()

    let rfidMonitor = RfidMonitor(tcpComm: tcpComm)
    let printerMonitor = PrinterMonitor(tcpComm: tcpComm)

    var choice = 0
    repeat {
        print("\nMenu:")
        print("1 - Get Printer Info")
        print("2 - Listen to RfidReport")
        print("3 - Print example file")
        print("4 - Exit")
        print("Enter your choice (1-4):")

        if let input = readLine(), let inputNumber = Int(input.trimmingCharacters(in: .whitespacesAndNewlines)) {
            choice = inputNumber
        }

        switch choice {
        case 1:
            let printerInfo = printerMonitor?.getPrinterInfo()
            print("\n======= RFID Printer Info: ")
            print("Printer Model: \(printerInfo?.model() ?? "")")
            print("Printer SN: \(printerInfo?.serialNumber() ?? "")")
            print("Printer FW PN: \(printerInfo?.firmwarePartNumber() ?? "")")
            print("Printer FW Ver: \(printerInfo?.firmwareVersion() ?? "")")
            print("Printhead Resolution (Dots/Inch): \(printerInfo?.printheadResolution() ?? "")")
            print("Has RFID: \((printerInfo?.hasRfidOption() == true) ? "Yes" : "No")")
            
        case 2:
            DispatchQueue.global().async {
                rfidMonitor?.rfidReportCallback = { report in
                    if ((report?.failed()) == nil) {
                        print("\nRFID Failed.")
                    } else {
                        print("\nRFID Passed.")
                        print("Write Action: \((report?.isWriteOperation() == true) ? "Yes" : "No")")
                        print("Data: \n\(report?.data() ?? "")")
                    }
                }
                rfidMonitor?.setRfidReportListening(true)
            }
            
        case 3:
            let tcpComm2 = TcpComm(ipAddress: "10.0.10.206", port: 9100)
            tcpComm2?.sendPrintFile("10.0.10.206", fileName: "/Users/realbuber/Documents/Project/UniPRT_python/example/rfid.pgl")
            print("Sending RFID print job...")
            
        case 4:
            print("Exiting...")
            
        default:
            print("Invalid choice. Please enter a number between 1 and 4.")
        }
    } while choice != 4
}

main()
