//
//  Defaults.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef Defaults_h
#define Defaults_h

#import <Foundation/Foundation.h>
#import <UniPRT/IRuler.h>
#import <UniPRT/CONST.h>
#import <UniPRT/IPrintResolution.h>
#import <UniPRT/IBarcode2D.h>
#import <UniPRT/AlignEnum.h>
#import <UniPRT/RotateEnum.h>
#import <UniPRT/ICellSquare.h>
#import <UniPRT/ICellRect.h>

/**
 * @~english
 * @class Defaults
 * @brief The defaults used for settings if not specified during object creation or set/changed.
 * @ingroup Interface
 *
 * @~chinese
 * @class Defaults
 * @brief 如果在对象创建期间或设置/更改时未指定的默认设置。
 * @ingroup Interface
 *
 * @~chinese_traditional
 * @class Defaults
 * @brief 如果在物件創建期間或設置/更改時未指定的默認設置。
 * @ingroup Interface
 */
@interface Defaults : NSObject

/**
 * @~english
 * @brief The printer resolution used for all objects created unless a different resolution is set.
 * The placement of objects within a plane depends on the printer resolution when using units other than dots.
 *
 * @~chinese
 * @brief 除非设置了不同的分辨率，否则用于所有对象创建的打印机分辨率。
 * 当使用非点单位时，对象在平面内的放置取决于打印机分辨率。
 *
 * @~chinese_traditional
 * @brief 除非設置了不同的分辨率，否則用於所有對象創建的打印機分辨率。
 * 當使用非點單位時，對象在平面內的放置取決於打印機分辨率。
 */
@property (class, nonatomic, strong) id<IPrintResolution> printerResolution;

/**
 * @~english
 * @brief The ruler used by all objects if a specific ruler is not changed or provided.
 * By changing the settings of this ruler, it allows all objects to use a common ruler scale/resolution.
 *
 * @~chinese
 * @brief 如果没有更改或提供特定标尺，所有对象使用的标尺。
 * 通过更改此标尺的设置，可以使所有对象使用通用的标尺比例/分辨率。
 *
 * @~chinese_traditional
 * @brief 如果沒有更改或提供特定標尺，所有對象使用的標尺。
 * 通過更改此標尺的設置，可以使所有對象使用通用的標尺比例/分辨率。
 */
@property (class, nonatomic, strong) id<IRuler> ruler;

/**
 * @~english
 * @brief Alignment setting for objects.
 *
 * @~chinese
 * @brief 对象的对齐设置。
 *
 * @~chinese_traditional
 * @brief 對象的對齊設置。
 */
@property (class, nonatomic, assign) AlignEnum alignment;

/**
 * @~english
 * @brief Rotation setting for objects.
 *
 * @~chinese
 * @brief 对象的旋转设置。
 *
 * @~chinese_traditional
 * @brief 對象的旋轉設置。
 */
@property (class, nonatomic, assign) RotateEnum rotation;

/**
 * @~english
 * @brief The cell/module size for 2D barcodes if no size is specified.
 *
 * @~chinese
 * @brief 如果未指定大小，2D 条码的单元/模块大小。
 *
 * @~chinese_traditional
 * @brief 如果未指定大小，2D 條碼的單元/模組大小。
 */
@property (class, nonatomic, strong) id<ICellSquare> cellSize;

/**
 * @~english
 * @brief The cell/module size for 2D barcodes if no size is specified.
 *
 * @~chinese
 * @brief 如果未指定大小，2D 条码的单元/模块大小。
 *
 * @~chinese_traditional
 * @brief 如果未指定大小，2D 條碼的單元/模組大小。
 */
@property (class, nonatomic, strong) id<ICellRect> cellSizeRect;

+ (id<IPrintResolution>)printerResolution;
+ (void)SetPrinterResolution:(id<IPrintResolution>)printerResolution;

+ (id<IRuler>)ruler;
+ (void)SetRuler:(id<IRuler>)ruler;

+ (AlignEnum)alignment;
+ (void)SetAlignment:(AlignEnum)alignment;

+ (RotateEnum)rotation;
+ (void)SetRotation:(RotateEnum)rotation;

+ (id<ICellSquare>)cellSize;
+ (void)SetCellSize:(id<ICellSquare>)cellSize;

+ (id<ICellRect>)cellSizeRect;
+ (void)SetCellSizeRect:(id<ICellRect>)cellSizeRect;

@end

#endif /* Defaults_h */
