//
//  ILine.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef ILine_h
#define ILine_h

// ILine.h
#import <Foundation/Foundation.h>
#import <UniPRT/IRuler.h>
#import <UniPRT/IPoint.h>

/**
 * \~English
 * @protocol ILine
 * @brief A protocol defining the interface for Line classes.
 * @ingroup Interface
 *
 * \~Chinese
 * @protocol ILine
 * @brief 定义线条类接口的协议。
 * @ingroup Interface
 *
 * \~Chinese-Traditional
 * @protocol ILine
 * @brief 定義線條類接口的協議。
 * @ingroup Interface
 */
@protocol ILine <NSObject>

/**
 * \~English
 * @brief The ruler used for placement. If not set, the default ruler setting is used.
 *
 * \~Chinese
 * @brief 用于放置的标尺。如果未设置，则使用默认标尺设置。
 *
 * \~Chinese-Traditional
 * @brief 用於放置的標尺。如果未設置，則使用默認標尺設置。
 */
@property (nonatomic, strong) id<IRuler> ruler;

/**
 * \~English
 * @brief Starting position of line.
 *
 * \~Chinese
 * @brief 线条的起始位置。
 *
 * \~Chinese-Traditional
 * @brief 線條的起始位置。
 */
@property (nonatomic, strong) id<IPoint> start;

/**
 * \~English
 * @brief Ending position of line.
 *
 * \~Chinese
 * @brief 线条的结束位置。
 *
 * \~Chinese-Traditional
 * @brief 線條的結束位置。
 */
@property (nonatomic, strong) id<IPoint> end;

/**
 * \~English
 * @brief Thickness of line based on the ruler units in use.
 *
 * \~Chinese
 * @brief 根据使用中的标尺单位确定线条的厚度。
 *
 * \~Chinese-Traditional
 * @brief 根據使用中的標尺單位確定線條的厚度。
 */
@property (nonatomic, assign) float lineThickness;

@end

#endif /* ILine_h */
