//
//  IRfidPassword.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef IRfidPassword_h
#define IRfidPassword_h

// IRfidPassword.h
#import <Foundation/Foundation.h>
#import <UniPRT/RfidPasswordTypeEnum.h>

/**
 * @~english
 * @protocol IRfidPassword
 *
 * @brief For cases where memory access is password protected.
 *
 * @ingroup Interface
 *
 * @~chinese
 * @protocol IRfidPassword
 *
 * @brief 用于内存访问受密码保护的情况。
 *
 * @ingroup Interface
 *
 * @~Chinese-Traditional
 * @protocol IRfidPassword
 *
 * @brief 用於內存訪問受密碼保護的情況。
 *
 * @ingroup Interface
 */
@protocol IRfidPassword <NSObject>

/**
 * @~english
 * @brief Select type of password for memory access.
 *
 * @~chinese
 * @brief 选择内存访问的密码类型。
 *
 * @~Chinese-Traditional
 * @brief 選擇內存訪問的密碼類型。
 */
@property (nonatomic, assign) RfidPasswordTypeEnum passwordType;

/**
 * @~english
 * @brief Optional password for tags that support it.
 *
 * @~chinese
 * @brief 支持密码的标签的可选密码。
 *
 * @~Chinese-Traditional
 * @brief 支持密碼的標籤的可選密碼。
 */
@property (nonatomic, strong) NSString *password;

@end

#endif /* IRfidPassword_h */
