//
//  ATextItem.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef ATextItem_h
#define ATextItem_h

// ATextItem.h
#import <Foundation/Foundation.h>

#import <UniPRT/ITextItem.h>
#import <UniPRT/IPoint.h>
#import <UniPRT/FontSize.h>

/**
 * @class ATextItem
 * @ingroup Interface
 * @~english
 * @brief Base class for ATextItem.
 * @~chinese
 * @brief ATextItem的基类。
 * @~Chinese-Traditional
 * @brief ATextItem的基類。
 */
@interface ATextItem : NSObject <ITextItem>
@property (nonatomic, strong) id<IPoint> start;
@property (nonatomic, strong) NSString *data;
@property (nonatomic, strong) id<IFontSize> fontSize;

- (instancetype)initWithStart:(id<IPoint>)start data:(NSString *)data;
@end

#endif /* ATextItem_h */
