#import "ViewController.h"

@import UniPRT;

@interface ViewController ()
@property (strong) TcpComm *tcpComm;
@property (nonatomic, strong) UITextField *ipTextField;
@property (nonatomic, strong) UITextView *resultTextView;
@property (nonatomic, strong) UITextView *callbackTextView;
@property (nonatomic, strong) UIButton *openButton;
@property (nonatomic, strong) UIButton *writeButton;
@property (nonatomic, strong) UIButton *readButton;
@property (nonatomic, strong) UIButton *connectCloseButton;
@property (nonatomic, strong) UITextView *textView;
@property (nonatomic, strong) UISegmentedControl *connectionSegmentedControl;
@property (nonatomic, strong) UIButton *connectshowPrinterInfoTestButton;
@property (nonatomic, strong) UIButton *connectPrinterMonitorTestButton;
@property (nonatomic, strong) UIButton *connectPrintTestButton;
@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    UIScrollView *scrollView = [[UIScrollView alloc] initWithFrame:self.view.bounds];
    scrollView.contentSize = CGSizeMake(self.view.bounds.size.width, 1500);
    scrollView.userInteractionEnabled = YES;
    scrollView.scrollEnabled = YES;
    [self.view addSubview:scrollView];
    
    // Create and configure IP address text field
    self.ipTextField = [[UITextField alloc] initWithFrame:CGRectMake(20, 50, 200, 30)];
    self.ipTextField.placeholder = @"Enter IP Address";
    self.ipTextField.borderStyle = UITextBorderStyleRoundedRect;
    [scrollView addSubview:self.ipTextField];
    self.ipTextField.text = @"10.0.10.180";
    
    // Create and configure result text view
    self.resultTextView = [[UITextView alloc] initWithFrame:CGRectMake(20, 150, 300, 200)];
    self.resultTextView.editable = NO;
    self.resultTextView.scrollEnabled = YES;
    self.resultTextView.layer.borderWidth = 1.0;
    self.resultTextView.layer.borderColor = [[UIColor blackColor] CGColor];
    [scrollView addSubview:self.resultTextView];
    
    // Create callback text view
    self.callbackTextView = [[UITextView alloc] initWithFrame:CGRectMake(20, 550, 300, 1000)];
    self.callbackTextView.editable = NO;
    self.callbackTextView.scrollEnabled = YES;
    self.callbackTextView.layer.borderWidth = 1.0;
    self.callbackTextView.layer.borderColor = [[UIColor blackColor] CGColor];
    [scrollView addSubview:self.callbackTextView];
    
    self.connectCloseButton = [self createButtonWithTitle:@"Connect" frame:CGRectMake(20, 370, 300, 30)];
    self.connectCloseButton.backgroundColor = [UIColor redColor];
    [self.connectCloseButton addTarget:self action:@selector(connectCloseButtonPressed) forControlEvents:UIControlEventTouchUpInside];
    [scrollView addSubview:self.connectCloseButton];
    
    // Create and configure buttons
    self.openButton = [self createButtonWithTitle:@"Open" frame:CGRectMake(20, 420, 300, 30)];
    self.openButton.backgroundColor = [UIColor redColor];
    [self.openButton addTarget:self action:@selector(openButtonPressed) forControlEvents:UIControlEventTouchUpInside];
    [scrollView addSubview:self.openButton];
    
    self.connectshowPrinterInfoTestButton = [self createButtonWithTitle:@"showPrinterInfoTest" frame:CGRectMake(20, 460, 300, 30)];
    self.connectshowPrinterInfoTestButton.backgroundColor = [UIColor redColor];
    [self.connectshowPrinterInfoTestButton addTarget:self action:@selector(showPrinterInfoTestButtonPressed) forControlEvents:UIControlEventTouchUpInside];
    [scrollView addSubview:self.connectshowPrinterInfoTestButton];
    
    self.connectPrinterMonitorTestButton = [self createButtonWithTitle:@"PrinterMonitorTest" frame:CGRectMake(20, 500, 300, 30)];
    self.connectPrinterMonitorTestButton.backgroundColor = [UIColor redColor];
    [self.connectPrinterMonitorTestButton addTarget:self action:@selector(connectPrinterMonitorTestButtonPressed) forControlEvents:UIControlEventTouchUpInside];
    [scrollView addSubview:self.connectPrinterMonitorTestButton];
    
    self.connectPrintTestButton = [self createButtonWithTitle:@"PrinterTest" frame:CGRectMake(20, 535, 300, 30)];
    self.connectPrintTestButton.backgroundColor = [UIColor redColor];
    [self.connectPrintTestButton addTarget:self action:@selector(connectPrintTestButtonPressed) forControlEvents:UIControlEventTouchUpInside];
    [scrollView addSubview:self.connectPrintTestButton];
}

- (UIButton *)createButtonWithTitle:(NSString *)title frame:(CGRect)frame {
    UIButton *button = [UIButton buttonWithType:UIButtonTypeCustom];
    button.frame = frame;
    [button setTitle:title forState:UIControlStateNormal];
    return button;
}

- (void)openButtonPressed {
    [self.tcpComm open];
}

- (void)connectCloseButtonPressed {
    NSString *currentTitle = [self.connectCloseButton titleForState:UIControlStateNormal];
    
    if ([currentTitle isEqualToString:@"Connect"]) {
        NSString *ipAddress = self.ipTextField.text;
        self.tcpComm = [[TcpComm alloc] initWithIPAddress:ipAddress port:DEFAULT_MGMT_PORT];
        [self.connectCloseButton setTitle:@"Close" forState:UIControlStateNormal];
    } else if ([currentTitle isEqualToString:@"Close"]) {
        [self.tcpComm close];
        [self.connectCloseButton setTitle:@"Connect" forState:UIControlStateNormal];
    }
}

- (void)showPrinterInfoTestButtonPressed {
    PrinterMonitor *printerMonitor = [[PrinterMonitor alloc] initWithTcpComm:self.tcpComm];
    PrinterInfo *printerInfo = [printerMonitor getPrinterInfo];
    NSMutableString *receivedString = [[NSMutableString alloc] init];
    [receivedString appendString:@"======= RFID Printer Info: \n"];
    [receivedString appendFormat:@"Printer Model: %@\n", printerInfo.model];
    [receivedString appendFormat:@"Printer SN: %@\n", printerInfo.serialNumber];
    [receivedString appendFormat:@"Printer FW PN: %@\n", printerInfo.firmwarePartNumber];
    [receivedString appendFormat:@"Printer FW Ver: %@\n", printerInfo.firmwareVersion];
    [receivedString appendFormat:@"Printhead Resolution (Dots/Inch): %@\n", printerInfo.printheadResolution];
    [receivedString appendFormat:@"Has odv: %@\n", printerInfo.hasOdvOption ? @"Yes" : @"No"];

    NSLog(@"%@", receivedString);
    self.resultTextView.text = receivedString;
}

- (void)connectPrinterMonitorTestButtonPressed {
    PrinterMonitor *printerMonitor = [[PrinterMonitor alloc] initWithTcpComm:self.tcpComm];
    NSMutableString *receivedString = [[NSMutableString alloc] init];
    
    printerMonitor.engineStatusCallback = ^(NSString *status) {
        NSLog(@"Engine status update: %@", status);
        [receivedString appendFormat:@"Engine status update: %@\n", status];
        dispatch_async(dispatch_get_main_queue(), ^{
            self.callbackTextView.text = receivedString;
        });
    };
    [printerMonitor SetEngineStatusListening:YES];
    
    printerMonitor.displayStatusCallback = ^(NSArray <NSString *> *status) {
        NSLog(@"Display status update: %@", [status componentsJoinedByString:@", "]);
        [receivedString appendFormat:@"Display status update: %@\n", [status componentsJoinedByString:@", "]];
        dispatch_async(dispatch_get_main_queue(), ^{
            self.callbackTextView.text = receivedString;
        });
    };
    [printerMonitor SetDisplayStatusListening:YES];
    
    printerMonitor.alertStatusCallback = ^(NSArray <NSString *> *status) {
        NSLog(@"Alert status update: %@", [status componentsJoinedByString:@", "]);
        [receivedString appendFormat:@"Alert status update: %@\n", [status componentsJoinedByString:@", "]];
        dispatch_async(dispatch_get_main_queue(), ^{
            self.callbackTextView.text = receivedString;
        });
    };
    [printerMonitor SetAlertStatusListening:YES];
}

- (void)connectPrintTestButtonPressed {
    NSString *ipAddress = self.ipTextField.text;
    TcpComm *tcpComm2 = [[TcpComm alloc] initWithIPAddress:ipAddress port:DEFAULT_DATA_PORT];
    [tcpComm2 sendPrintFile:ipAddress fileName:@"/Users/realbuber/Documents/Objective-C IOS SDK example/Objective-C/TestPrinterMonitor/Hello_1.pgl"];
    NSLog(@"Sending print job...");
}

@end
