//
//  TextItem.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef TextItem_h
#define TextItem_h

// TextItem.h
#import <Foundation/Foundation.h>

#import <UniPRT/ATextItem.h>
#import <UniPRT/IPoint.h>
#import <UniPRT/FontSize.h>
#import <UniPRT/Point.h>

/**
 * @class TextItem
 * @ingroup Interface
 *
 * @~english
 * @brief A class for TextItem, inheriting from ITextItem.
 *
 * @~chinese
 * @brief TextItem 类，继承自 ITextItem。
 *
 * @~Chinese-Traditional
 * @brief TextItem 類，繼承自 ITextItem。
 */

@interface TextItem : ATextItem

// Designated initializers
- (instancetype)initWithStart:(id<IPoint>)start data:(NSString *)data;
- (instancetype)initWithStart:(id<IPoint>)start fontSize:(id<IFontSize>)size data:(NSString *)data;

// Convenience initializers
- (instancetype)initWithX:(float)xStart y:(float)yStart data:(NSString *)data;
- (instancetype)initWithX:(float)xStart y:(float)yStart sizeX:(float)sizeX sizeY:(float)sizeY data:(NSString *)data;

@end

#endif /* TextItem_h */
