//
//  PglMaxicodeMsg.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/27.
//

#ifndef PglMaxicodeMsg_h
#define PglMaxicodeMsg_h

#import <Foundation/Foundation.h>
#import <UniPRT/AMaxicodeMsg.h>

/**
 * \~English
 * @class PglMaxicodeMsg
 * @brief A class representing a Maxicode message.
 *
 * This class inherits from AMaxicodeMsg and provides functionality for initializing
 * and accessing the data of a Maxicode message.
 *
 * @ingroup PGL
 *
 * \~Chinese
 * @class PglMaxicodeMsg
 * @brief 表示Maxicode消息的类。
 *
 * 该类继承自AMaxicodeMsg，并提供了初始化和访问Maxicode消息数据的功能。
 *
 * @ingroup PGL
 *
 * \~Chinese-Traditional
 * @class PglMaxicodeMsg
 * @brief 表示Maxicode消息的類。
 *
 * 該類繼承自AMaxicodeMsg，並提供了初始化和訪問Maxicode消息數據的功能。
 *
 * @ingroup PGL
 */
@interface PglMaxicodeMsg : AMaxicodeMsg

/**
 * \~English
 * @brief Initializes a new instance of the PglMaxicodeMsg class with the specified mode, primary message, and remaining message.
 *
 * @param mode The mode of the Maxicode.
 * @param primaryMsg The primary message to be encoded.
 * @param remainingMsg The remaining message to be encoded.
 * @return A new instance of PglMaxicodeMsg.
 *
 * \~Chinese
 * @brief 使用指定的模式、主消息和剩余消息初始化PglMaxicodeMsg类的新实例。
 *
 * @param mode Maxicode的模式。
 * @param primaryMsg 要编码的主消息。
 * @param remainingMsg 要编码的剩余消息。
 * @return PglMaxicodeMsg的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的模式、主消息和剩餘消息初始化PglMaxicodeMsg類的新實例。
 *
 * @param mode Maxicode的模式。
 * @param primaryMsg 要編碼的主消息。
 * @param remainingMsg 要編碼的剩餘消息。
 * @return PglMaxicodeMsg的新實例。
 */
- (instancetype)initWithMode:(MaxicodeModeEnum)mode primaryMsg:(NSString *)primaryMsg remainingMsg:(NSString *)remainingMsg;

/**
 * \~English
 * @brief The encoded data of the Maxicode message.
 *
 * \~Chinese
 * @brief Maxicode消息的编码数据。
 *
 * \~Chinese-Traditional
 * @brief Maxicode消息的編碼數據。
 */
@property (nonatomic, copy, readonly) NSString *data;

@end

#endif /* PglMaxicodeMsg_h */
